/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter.ccitt;

import com.tom_roush.pdfbox.filter.ccitt.CCITTFaxConstants;
import com.tom_roush.pdfbox.filter.ccitt.PackedBitArray;
import java.io.IOException;
import java.io.InputStream;

public final class CCITTFaxG31DDecodeInputStream
extends InputStream {
    private static final int CODE_WORD = 0;
    private static final int SIGNAL_EOD = -1;
    private static final int SIGNAL_EOL = -2;
    private InputStream source;
    private int columns;
    private int rows;
    private boolean encodedByteAlign;
    private int bits;
    private int bitPos = 8;
    private PackedBitArray decodedLine;
    private int decodedWritePos;
    private int decodedReadPos;
    private int y = -1;
    private int accumulatedRunLength;
    private static final NonLeafLookupTreeNode WHITE_LOOKUP_TREE_ROOT = new NonLeafLookupTreeNode();
    private static final NonLeafLookupTreeNode BLACK_LOOKUP_TREE_ROOT = new NonLeafLookupTreeNode();
    private static final int[] BIT_POS_MASKS;
    private static final short EOL_STARTER = 2816;

    public CCITTFaxG31DDecodeInputStream(InputStream source, int columns, int rows, boolean encodedByteAlign) {
        this.source = source;
        this.columns = columns;
        this.rows = rows;
        this.decodedLine = new PackedBitArray(columns);
        this.decodedReadPos = this.decodedLine.getByteCount();
        this.encodedByteAlign = encodedByteAlign;
    }

    public CCITTFaxG31DDecodeInputStream(InputStream source, int columns, boolean encodedByteAlign) {
        this(source, columns, 0, encodedByteAlign);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        boolean hasLine;
        if (this.decodedReadPos >= this.decodedLine.getByteCount() && !(hasLine = this.decodeLine())) {
            return -1;
        }
        byte data = this.decodedLine.getData()[this.decodedReadPos++];
        return data & 0xFF;
    }

    private boolean decodeLine() throws IOException {
        if (this.encodedByteAlign && this.bitPos != 0) {
            this.readByte();
        }
        if (this.bits < 0) {
            return false;
        }
        ++this.y;
        int x = 0;
        if (this.rows > 0 && this.y >= this.rows) {
            return false;
        }
        this.decodedLine.clear();
        this.decodedWritePos = 0;
        int expectRTC = 6;
        boolean white = true;
        while (x < this.columns || this.accumulatedRunLength > 0) {
            NonLeafLookupTreeNode root = white ? WHITE_LOOKUP_TREE_ROOT : BLACK_LOOKUP_TREE_ROOT;
            CodeWord code = ((LookupTreeNode)root).getNextCodeWord(this);
            if (code == null) {
                if (x > 0) {
                    this.decodedReadPos = 0;
                    return true;
                }
                return false;
            }
            if (code.getType() == -2) {
                if (--expectRTC == 0) {
                    return false;
                }
                if (x != 0) continue;
                continue;
            }
            expectRTC = -1;
            x += code.execute(this);
            if (this.accumulatedRunLength != 0) continue;
            white = !white;
        }
        this.decodedReadPos = 0;
        return true;
    }

    private void writeRun(int bit, int length) {
        this.accumulatedRunLength += length;
        if (bit != 0) {
            this.decodedLine.setBits(this.decodedWritePos, this.accumulatedRunLength);
        }
        this.decodedWritePos += this.accumulatedRunLength;
        this.accumulatedRunLength = 0;
    }

    private void writeNonTerminating(int length) {
        this.accumulatedRunLength += length;
    }

    private int readBit() throws IOException {
        if (this.bitPos >= 8) {
            this.readByte();
            if (this.bits < 0) {
                return -1;
            }
        }
        return (this.bits & BIT_POS_MASKS[this.bitPos++]) == 0 ? 0 : 1;
    }

    private void readByte() throws IOException {
        this.bits = this.source.read();
        this.bitPos = 0;
    }

    private static void buildLookupTree() {
        CCITTFaxG31DDecodeInputStream.buildUpTerminating(CCITTFaxConstants.WHITE_TERMINATING, WHITE_LOOKUP_TREE_ROOT, true);
        CCITTFaxG31DDecodeInputStream.buildUpTerminating(CCITTFaxConstants.BLACK_TERMINATING, BLACK_LOOKUP_TREE_ROOT, false);
        CCITTFaxG31DDecodeInputStream.buildUpMakeUp(CCITTFaxConstants.WHITE_MAKE_UP, WHITE_LOOKUP_TREE_ROOT);
        CCITTFaxG31DDecodeInputStream.buildUpMakeUp(CCITTFaxConstants.BLACK_MAKE_UP, BLACK_LOOKUP_TREE_ROOT);
        CCITTFaxG31DDecodeInputStream.buildUpMakeUpLong(CCITTFaxConstants.LONG_MAKE_UP, WHITE_LOOKUP_TREE_ROOT);
        CCITTFaxG31DDecodeInputStream.buildUpMakeUpLong(CCITTFaxConstants.LONG_MAKE_UP, BLACK_LOOKUP_TREE_ROOT);
        EndOfLineTreeNode eolNode = new EndOfLineTreeNode();
        CCITTFaxG31DDecodeInputStream.addLookupTreeNode((short)2816, WHITE_LOOKUP_TREE_ROOT, eolNode);
        CCITTFaxG31DDecodeInputStream.addLookupTreeNode((short)2816, BLACK_LOOKUP_TREE_ROOT, eolNode);
    }

    private static void buildUpTerminating(short[] codes, NonLeafLookupTreeNode root, boolean white) {
        int c = codes.length;
        for (int len = 0; len < c; ++len) {
            RunLengthTreeNode leaf = new RunLengthTreeNode(white ? 0 : 1, len);
            CCITTFaxG31DDecodeInputStream.addLookupTreeNode(codes[len], root, leaf);
        }
    }

    private static void buildUpMakeUp(short[] codes, NonLeafLookupTreeNode root) {
        int c = codes.length;
        for (int len = 0; len < c; ++len) {
            MakeUpTreeNode leaf = new MakeUpTreeNode((len + 1) * 64);
            CCITTFaxG31DDecodeInputStream.addLookupTreeNode(codes[len], root, leaf);
        }
    }

    private static void buildUpMakeUpLong(short[] codes, NonLeafLookupTreeNode root) {
        int c = codes.length;
        for (int len = 0; len < c; ++len) {
            MakeUpTreeNode leaf = new MakeUpTreeNode((len + 28) * 64);
            CCITTFaxG31DDecodeInputStream.addLookupTreeNode(codes[len], root, leaf);
        }
    }

    private static void addLookupTreeNode(short code, NonLeafLookupTreeNode root, LookupTreeNode leaf) {
        int codeLength = code >> 8;
        int pattern = code & 0xFF;
        NonLeafLookupTreeNode node = root;
        for (int p = codeLength - 1; p > 0; --p) {
            int bit = pattern >> p & 1;
            LookupTreeNode child = node.get(bit);
            if (child == null) {
                child = new NonLeafLookupTreeNode();
                node.set(bit, child);
            }
            if (!(child instanceof NonLeafLookupTreeNode)) {
                throw new IllegalStateException("NonLeafLookupTreeNode expected, was " + child.getClass().getName());
            }
            node = (NonLeafLookupTreeNode)child;
        }
        int bit = pattern & 1;
        if (node.get(bit) != null) {
            throw new IllegalStateException("Two codes conflicting in lookup tree");
        }
        node.set(bit, leaf);
    }

    static {
        CCITTFaxG31DDecodeInputStream.buildLookupTree();
        BIT_POS_MASKS = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    }

    private static class EndOfLineTreeNode
    extends LookupTreeNode
    implements CodeWord {
        private EndOfLineTreeNode() {
        }

        @Override
        public CodeWord getNextCodeWord(CCITTFaxG31DDecodeInputStream decoder) throws IOException {
            int bit;
            while ((bit = decoder.readBit()) == 0) {
            }
            if (bit < 0) {
                return null;
            }
            return this;
        }

        @Override
        public int execute(CCITTFaxG31DDecodeInputStream decoder) throws IOException {
            return 0;
        }

        @Override
        public int getType() {
            return -2;
        }

        public String toString() {
            return "EOL";
        }
    }

    private static class MakeUpTreeNode
    extends LookupTreeNode
    implements CodeWord {
        private final int length;

        MakeUpTreeNode(int length) {
            this.length = length;
        }

        @Override
        public CodeWord getNextCodeWord(CCITTFaxG31DDecodeInputStream decoder) throws IOException {
            return this;
        }

        @Override
        public int execute(CCITTFaxG31DDecodeInputStream decoder) throws IOException {
            decoder.writeNonTerminating(this.length);
            return this.length;
        }

        @Override
        public int getType() {
            return 0;
        }

        public String toString() {
            return "Make up code for length " + this.length;
        }
    }

    private static class RunLengthTreeNode
    extends LookupTreeNode
    implements CodeWord {
        private final int bit;
        private final int length;

        RunLengthTreeNode(int bit, int length) {
            this.bit = bit;
            this.length = length;
        }

        @Override
        public CodeWord getNextCodeWord(CCITTFaxG31DDecodeInputStream decoder) throws IOException {
            return this;
        }

        @Override
        public int execute(CCITTFaxG31DDecodeInputStream decoder) {
            decoder.writeRun(this.bit, this.length);
            return this.length;
        }

        @Override
        public int getType() {
            return 0;
        }

        public String toString() {
            return "Run Length for " + this.length + " bits of " + (this.bit == 0 ? "white" : "black");
        }
    }

    private static class NonLeafLookupTreeNode
    extends LookupTreeNode {
        private LookupTreeNode zero;
        private LookupTreeNode one;

        private NonLeafLookupTreeNode() {
        }

        public void set(int bit, LookupTreeNode node) {
            if (bit == 0) {
                this.zero = node;
            } else {
                this.one = node;
            }
        }

        public LookupTreeNode get(int bit) {
            return bit == 0 ? this.zero : this.one;
        }

        @Override
        public CodeWord getNextCodeWord(CCITTFaxG31DDecodeInputStream decoder) throws IOException {
            int bit = decoder.readBit();
            if (bit < 0) {
                return null;
            }
            LookupTreeNode node = this.get(bit);
            if (node != null) {
                return node.getNextCodeWord(decoder);
            }
            throw new IOException("Invalid code word encountered");
        }
    }

    private static interface CodeWord {
        public int getType();

        public int execute(CCITTFaxG31DDecodeInputStream var1) throws IOException;
    }

    private static abstract class LookupTreeNode {
        private LookupTreeNode() {
        }

        public abstract CodeWord getNextCodeWord(CCITTFaxG31DDecodeInputStream var1) throws IOException;
    }
}

