/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.filter.DecodeResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Filter {
    protected Filter() {
    }

    public abstract DecodeResult decode(InputStream var1, OutputStream var2, COSDictionary var3, int var4) throws IOException;

    public final void encode(InputStream input, OutputStream encoded, COSDictionary parameters, int index) throws IOException {
        this.encode(input, encoded, parameters.asUnmodifiableDictionary());
    }

    protected abstract void encode(InputStream var1, OutputStream var2, COSDictionary var3) throws IOException;

    protected static COSDictionary getDecodeParams(COSDictionary dictionary, int index) {
        COSBase obj = dictionary.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP);
        if (obj instanceof COSDictionary) {
            return (COSDictionary)obj;
        }
        if (obj instanceof COSArray) {
            COSArray array = (COSArray)obj;
            if (index < array.size()) {
                return (COSDictionary)array.getObject(index);
            }
        } else if (obj != null) {
            Log.e((String)"PdfBox-Android", (String)("Expected DecodeParams to be an Array or Dictionary but found " + obj.getClass().getName()));
        }
        return new COSDictionary();
    }
}

