/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.cos;

import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.filter.DecodeResult;
import com.tom_roush.pdfbox.filter.Filter;
import com.tom_roush.pdfbox.io.RandomAccess;
import com.tom_roush.pdfbox.io.RandomAccessInputStream;
import com.tom_roush.pdfbox.io.RandomAccessOutputStream;
import com.tom_roush.pdfbox.io.ScratchFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class COSInputStream
extends FilterInputStream {
    private final List<DecodeResult> decodeResults;

    static COSInputStream create(List<Filter> filters, COSDictionary parameters, InputStream in, ScratchFile scratchFile) throws IOException {
        ArrayList<DecodeResult> results = new ArrayList<DecodeResult>();
        InputStream input = in;
        if (filters.isEmpty()) {
            input = in;
        } else {
            for (int i = 0; i < filters.size(); ++i) {
                DecodeResult result;
                if (scratchFile != null) {
                    final RandomAccess buffer = scratchFile.createBuffer();
                    result = filters.get(i).decode(input, new RandomAccessOutputStream(buffer), parameters, i);
                    results.add(result);
                    input = new RandomAccessInputStream(buffer){

                        @Override
                        public void close() throws IOException {
                            buffer.close();
                        }
                    };
                    continue;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                result = filters.get(i).decode(input, output, parameters, i);
                results.add(result);
                input = new ByteArrayInputStream(output.toByteArray());
            }
        }
        return new COSInputStream(input, results);
    }

    private COSInputStream(InputStream input, List<DecodeResult> decodeResults) {
        super(input);
        this.decodeResults = decodeResults;
    }

    public DecodeResult getDecodeResult() {
        if (this.decodeResults.isEmpty()) {
            return DecodeResult.DEFAULT;
        }
        return this.decodeResults.get(this.decodeResults.size() - 1);
    }
}

