/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.ttf;

import com.tom_roush.fontbox.ttf.TTFDataStream;
import com.tom_roush.fontbox.ttf.TTFTable;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VerticalOriginTable
extends TTFTable {
    public static final String TAG = "VORG";
    private float version;
    private int defaultVertOriginY;
    private Map<Integer, Integer> origins = new ConcurrentHashMap<Integer, Integer>();

    VerticalOriginTable(TrueTypeFont font) {
        super(font);
    }

    @Override
    public void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        this.version = data.read32Fixed();
        this.defaultVertOriginY = data.readSignedShort();
        int numVertOriginYMetrics = data.readUnsignedShort();
        for (int i = 0; i < numVertOriginYMetrics; ++i) {
            int g = data.readUnsignedShort();
            short y = data.readSignedShort();
            this.origins.put(g, Integer.valueOf(y));
        }
        this.initialized = true;
    }

    public float getVersion() {
        return this.version;
    }

    public int getOriginY(int gid) {
        if (this.origins.containsKey(gid)) {
            return this.origins.get(gid);
        }
        return this.defaultVertOriginY;
    }
}

