/*
 * Decompiled with CFR 0.152.
 */
package com.tokopedia.expandable;

import android.content.Context;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.tokopedia.expandable.BaseExpandableOptionRadio;
import com.tokopedia.expandable.ExpandableOptionRadio;
import com.tokopedia.expandable.SavedState;

public class RadioGroupExpandable
extends LinearLayout
implements BaseExpandableOptionRadio.OnRadioCheckChangedListener {
    private int checkedId = -1;
    private OnCheckedChangeListener onCheckedChangeListener;

    public RadioGroupExpandable(Context context) {
        super(context);
        this.setOrientation(1);
        this.init();
    }

    public RadioGroupExpandable(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.checkedId != -1) {
            this.setCheckedStateForView(this.checkedId, true);
            this.setCheckedId(this.checkedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof ExpandableOptionRadio) {
            ((ExpandableOptionRadio)child).setOnRadioCheckChangedListener(this);
            if (((ExpandableOptionRadio)child).isExpanded()) {
                this.checkedId = child.getId();
            }
        }
        super.addView(child, index, params);
    }

    public void check(@IdRes int id2) {
        if (id2 != -1 && id2 == this.checkedId) {
            return;
        }
        if (this.checkedId != -1) {
            this.setCheckedStateForView(this.checkedId, false);
        }
        if (id2 != -1) {
            this.setCheckedStateForView(id2, true);
        }
        this.setCheckedId(id2);
    }

    private void setCheckedId(@IdRes int id2) {
        this.checkedId = id2;
        if (this.onCheckedChangeListener != null) {
            this.onCheckedChangeListener.onCheckedChanged(this, this.checkedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView != null && checkedView instanceof ExpandableOptionRadio) {
            ((ExpandableOptionRadio)checkedView).setExpand(checked);
        }
    }

    @IdRes
    public int getCheckedRadioButtonId() {
        return this.checkedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }

    @Override
    public void onCheckChangedListener(BaseExpandableOptionRadio expandableOptionRadio, int id2, boolean isChecked) {
        this.check(id2);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.childrenStates = new SparseArray();
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).saveHierarchyState(ss.childrenStates);
        }
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).restoreHierarchyState(ss.childrenStates);
        }
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RadioGroupExpandable var1, @IdRes int var2);
    }
}

