/*
 * Decompiled with CFR 0.152.
 */
package com.tokopedia.expandable;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import com.tokopedia.expandable.BaseExpandableOption;

public abstract class BaseExpandableOptionRadio
extends BaseExpandableOption {
    private OnRadioCheckChangedListener onRadioCheckChangedListener;

    public BaseExpandableOptionRadio(Context context) {
        super(context);
    }

    public void setOnRadioCheckChangedListener(OnRadioCheckChangedListener onRadioCheckChangedListener) {
        this.onRadioCheckChangedListener = onRadioCheckChangedListener;
    }

    public BaseExpandableOptionRadio(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseExpandableOptionRadio(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public BaseExpandableOptionRadio(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void initView(View view) {
        CompoundButton checkable = this.getCheckable();
        if (checkable != null) {
            this.getCheckable().setText((CharSequence)this.titleText);
            checkable.setChecked(this.isExpanded());
            checkable.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                    BaseExpandableOptionRadio.this.onHeaderClicked();
                }
            });
        }
        this.setExpand(this.isExpanded());
    }

    public abstract CompoundButton getCheckable();

    private void onRadioClicked() {
        this.setExpand(true);
        if (this.onRadioCheckChangedListener != null) {
            this.onRadioCheckChangedListener.onCheckChangedListener(this, this.getId(), true);
        }
    }

    @Override
    protected void onHeaderClicked() {
        if (!this.isExpanded()) {
            this.onRadioClicked();
        }
    }

    @Override
    public void setExpand(boolean b) {
        CompoundButton compoundButton;
        if (b != this.isExpanded() && (compoundButton = this.getCheckable()) != null) {
            compoundButton.setChecked(b);
        }
        super.setExpand(b);
    }

    @Override
    public void setTitleText(String titleText) {
        if (this.getCheckable() != null) {
            this.getCheckable().setText((CharSequence)titleText);
        }
        super.setTitleText(titleText);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getCheckable() != null) {
            this.getCheckable().setEnabled(enabled);
        }
    }

    public static interface OnRadioCheckChangedListener {
        public void onCheckChangedListener(BaseExpandableOptionRadio var1, int var2, boolean var3);
    }
}

