/*
 * Decompiled with CFR 0.152.
 */
package com.tokopedia.expandable;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import com.tokopedia.expandable.BaseExpandableOptionText;
import com.tokopedia.expandable.R;

public class ExpandableOptionArrow
extends BaseExpandableOptionText {
    private ImageView imageArrow;
    private Drawable imageUp;
    private Drawable imageDown;
    boolean isUseRotateAnimation;
    private View contentHeader;
    private boolean hasFinishInflate = false;

    public ExpandableOptionArrow(Context context) {
        super(context);
    }

    public ExpandableOptionArrow(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ExpandableOptionArrow(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ExpandableOptionArrow(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void init() {
        this.setHeaderLayoutRes(R.layout.item_expandable_option_arrow_header);
        super.init();
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        this.hasFinishInflate = false;
        TypedArray styledAttributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.BaseExpandableOption);
        try {
            this.imageUp = styledAttributes.getDrawable(R.styleable.BaseExpandableOption_eo_image_arrow_up);
            this.imageDown = styledAttributes.getDrawable(R.styleable.BaseExpandableOption_eo_image_arrow_down);
            this.isUseRotateAnimation = styledAttributes.getBoolean(R.styleable.BaseExpandableOption_eo_use_rotate_animation, false);
        }
        finally {
            styledAttributes.recycle();
        }
        if (this.imageDown == null) {
            this.imageDown = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_arrow_down);
        }
        if (this.imageUp == null) {
            this.imageUp = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_arrow_up);
        }
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.contentHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ExpandableOptionArrow.this.isEnabled()) {
                    ExpandableOptionArrow.this.toggle();
                }
            }
        });
        this.hasFinishInflate = true;
    }

    @Override
    public void setExpand(boolean isExpanded) {
        super.setExpand(isExpanded);
        if (isExpanded) {
            if (this.isUseRotateAnimation) {
                this.animateExpand(this.hasFinishInflate);
            } else {
                this.imageArrow.setImageDrawable(this.imageUp);
            }
        } else if (this.isUseRotateAnimation) {
            this.animateCollapse(this.hasFinishInflate);
        } else {
            this.imageArrow.setImageDrawable(this.imageDown);
        }
    }

    private void animateExpand(boolean isAnimate) {
        this.imageArrow.setImageDrawable(this.imageDown);
        RotateAnimation rotate = new RotateAnimation(360.0f, 180.0f, 1, 0.5f, 1, 0.5f);
        if (isAnimate) {
            rotate.setDuration(300L);
        } else {
            rotate.setDuration(1L);
        }
        rotate.setFillAfter(true);
        this.imageArrow.startAnimation((Animation)rotate);
    }

    private void animateCollapse(boolean isAnimate) {
        this.imageArrow.setImageDrawable(this.imageDown);
        RotateAnimation rotate = new RotateAnimation(180.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        if (isAnimate) {
            rotate.setDuration(300L);
        } else {
            rotate.setDuration(1L);
        }
        rotate.setFillAfter(true);
        this.imageArrow.startAnimation((Animation)rotate);
    }

    @Override
    protected void initView(View view) {
        super.initView(view);
        this.imageArrow = (ImageView)view.findViewById(R.id.image_arrow);
        this.contentHeader = view.findViewById(R.id.content_header_option);
    }
}

