/*
 * Decompiled with CFR 0.152.
 */
package com.tokopedia.expandable;

import android.animation.LayoutTransition;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v7.view.ContextThemeWrapper;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import com.tokopedia.expandable.R;
import com.tokopedia.expandable.SavedState;

public abstract class BaseExpandableOption
extends LinearLayout
implements View.OnClickListener {
    protected String titleText = "";
    private ExpandableListener expandableListener;
    private ViewGroup vgHeader;
    protected ViewGroup expandableChildViewLinear;
    private boolean optionChecked;
    private boolean optionEnabled = true;
    private View headerView;
    private View footerView;
    private int headerLayoutRes;
    private int footerLayoutRes;
    private boolean isEnableAnimation;
    private ViewGroup vgRoot;

    public BaseExpandableOption(Context context) {
        super(context);
        this.init();
    }

    public BaseExpandableOption(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
        this.init();
    }

    public BaseExpandableOption(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
        this.init();
    }

    @TargetApi(value=21)
    public BaseExpandableOption(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
        this.init();
    }

    private void checkParentAnimation() {
        if (this.getParent() != null) {
            ViewGroup parent = (ViewGroup)this.getParent();
            LayoutTransition lt = parent.getLayoutTransition();
            if (this.isEnableAnimation) {
                if (lt == null) {
                    lt = new LayoutTransition();
                }
                lt.enableTransitionType(4);
                parent.setLayoutTransition(lt);
            }
        }
    }

    public int getOrientation() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(AttributeSet attributeSet) {
        int expandableLayoutTheme;
        TypedArray styledAttributes = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.BaseExpandableOption);
        try {
            expandableLayoutTheme = styledAttributes.getResourceId(R.styleable.BaseExpandableOption_eo_theme, R.style.style_expandable_option_default);
            this.optionChecked = styledAttributes.getBoolean(R.styleable.BaseExpandableOption_eo_checked, false);
            this.titleText = styledAttributes.getString(R.styleable.BaseExpandableOption_eo_title);
            this.optionEnabled = styledAttributes.getBoolean(R.styleable.BaseExpandableOption_eo_enabled, true);
            this.headerLayoutRes = styledAttributes.getResourceId(R.styleable.BaseExpandableOption_eo_header_layout, -1);
            this.isEnableAnimation = styledAttributes.getBoolean(R.styleable.BaseExpandableOption_eo_enable_animation, false);
        }
        finally {
            styledAttributes.recycle();
        }
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.getContext(), this.getContext().getTheme());
        contextThemeWrapper.setTheme(expandableLayoutTheme);
    }

    protected void init() {
        this.setOrientation(this.getOrientation());
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View view = inflater.inflate(R.layout.item_expandable_option_base, (ViewGroup)this, false);
        this.vgRoot = (ViewGroup)view.findViewById(R.id.vg_root);
        this.setEnableAnimation(this.isEnableAnimation);
        this.vgHeader = (ViewGroup)view.findViewById(R.id.content_header_option);
        this.setUpHeaderFromRes();
        this.expandableChildViewLinear = (ViewGroup)view.findViewById(R.id.expandable_view);
        this.setUpFooterFromRes();
        this.addView(view);
        this.initView(view);
        this.setExpand(this.optionChecked);
        this.setEnabled(this.optionEnabled);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                BaseExpandableOption.this.checkParentAnimation();
                if (Build.VERSION.SDK_INT < 16) {
                    BaseExpandableOption.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    BaseExpandableOption.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
    }

    public void setEnableAnimation(boolean enableAnimation) {
        this.isEnableAnimation = enableAnimation;
        if (this.vgRoot == null) {
            return;
        }
        if (this.isEnableAnimation) {
            LayoutTransition layoutTransition = this.vgRoot.getLayoutTransition();
            if (layoutTransition == null) {
                layoutTransition = new LayoutTransition();
            }
            layoutTransition.setStartDelay(1, 0L);
            layoutTransition.disableTransitionType(0);
            layoutTransition.disableTransitionType(2);
            this.vgRoot.setLayoutTransition(layoutTransition);
        } else {
            this.vgRoot.setLayoutTransition(null);
        }
        this.checkParentAnimation();
    }

    private void setUpHeaderFromRes() {
        if (this.getRootView() != null && this.headerLayoutRes > 0 && this.vgHeader != null) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
            View headerView = inflater.inflate(this.headerLayoutRes, (ViewGroup)this.getRootView(), false);
            this.setHeaderView(headerView);
        }
    }

    private void setUpFooterFromRes() {
        if (this.getRootView() != null && this.footerLayoutRes > 0 && this.expandableChildViewLinear != null) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
            View footerView = inflater.inflate(this.footerLayoutRes, (ViewGroup)this.getRootView(), false);
            this.setFooterView(footerView);
        }
    }

    public boolean isHeaderCanToogle() {
        return true;
    }

    public void setHeaderView(View customHeaderView) {
        if (customHeaderView != null) {
            if (this.headerView != null && this.headerView.getParent() != null) {
                ((ViewGroup)this.headerView.getParent()).removeView(this.headerView);
            }
            this.headerView = customHeaderView;
            this.vgHeader.addView(customHeaderView, 0);
            if (this.isHeaderCanToogle()) {
                customHeaderView.setClickable(true);
                customHeaderView.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    public void setFooterView(View customFooterView) {
        if (customFooterView != null) {
            if (this.footerView != null && this.footerView.getParent() != null) {
                ((ViewGroup)this.footerView.getParent()).removeView(this.footerView);
            }
            this.footerView = customFooterView;
            this.expandableChildViewLinear.addView(customFooterView);
        }
    }

    public void toggle() {
        if (this.isExpanded()) {
            this.setExpand(false);
        } else {
            this.setExpand(true);
        }
    }

    public void setExpand(boolean isExpanded) {
        if (isExpanded) {
            this.expandableChildViewLinear.setVisibility(0);
        } else {
            this.expandableChildViewLinear.setVisibility(8);
        }
        if (this.expandableListener != null) {
            this.expandableListener.onExpandViewChange(isExpanded);
        }
    }

    public boolean isExpanded() {
        return this.expandableChildViewLinear.getVisibility() == 0;
    }

    public boolean isChecked() {
        return this.isExpanded();
    }

    public void setChecked(boolean isChecked) {
        this.setExpand(isChecked);
    }

    protected void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    protected String getTitleText() {
        return this.titleText;
    }

    public void setExpandableListener(ExpandableListener expandableListener) {
        this.expandableListener = expandableListener;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child.getId() == R.id.vg_root) {
            super.addView(child, index, params);
        } else {
            if (child.getParent() != null) {
                ViewGroup viewParent = (ViewGroup)child.getParent();
                viewParent.removeView(child);
            }
            this.expandableChildViewLinear.addView(child, params);
        }
    }

    protected abstract void initView(View var1);

    public void setHeaderLayoutRes(int headerLayoutRes) {
        this.headerLayoutRes = headerLayoutRes;
        this.setUpHeaderFromRes();
    }

    public void setFooterLayoutRes(int footerLayoutRes) {
        this.footerLayoutRes = footerLayoutRes;
        this.setUpFooterFromRes();
    }

    public void onClick(View view) {
        if (view == this.headerView && this.isEnabled()) {
            this.onHeaderClicked();
        }
    }

    protected void onHeaderClicked() {
        this.toggle();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.childrenStates = new SparseArray();
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).saveHierarchyState(ss.childrenStates);
        }
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).restoreHierarchyState(ss.childrenStates);
        }
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    public static interface ExpandableListener {
        public void onExpandViewChange(boolean var1);
    }
}

