/*
 * Decompiled with CFR 0.152.
 */
package com.tokopedia.expandable;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import com.tokopedia.expandable.BaseExpandableOption;
import com.tokopedia.expandable.R;
import com.tokopedia.expandable.RadioButtonExpandable;

public class ExpandableOptionRadio
extends BaseExpandableOption {
    private RadioButtonExpandable radioButton;
    private int radioId = -1;

    public ExpandableOptionRadio(Context context) {
        super(context);
    }

    public ExpandableOptionRadio(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ExpandableOptionRadio(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ExpandableOptionRadio(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.radioButton.setText(this.titleText);
        this.radioButton.setChecked(this.optionChecked);
        this.setVisibleChildView(this.optionChecked);
        this.radioButton.addOnCheckedChangeListener(this.onCheckedChangeRadio());
        this.invalidate();
        this.requestLayout();
    }

    @Override
    protected int getLayoutRes() {
        return R.layout.item_expandable_option_radio;
    }

    @Override
    protected void initView(View view) {
        this.radioButton = (RadioButtonExpandable)view.findViewById(R.id.radio_button);
        this.radioButton.setId(this.radioId);
    }

    @Override
    protected void init(AttributeSet attrs) {
        TypedArray styledAttributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableOption);
        try {
            this.radioId = styledAttributes.getResourceId(R.styleable.ExpandableOption_radio_id, -1);
        }
        finally {
            styledAttributes.recycle();
        }
        super.init(attrs);
    }

    private CompoundButton.OnCheckedChangeListener onCheckedChangeRadio() {
        return new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                ExpandableOptionRadio.this.setVisibleChildView(b);
            }
        };
    }

    @Override
    protected void setChecked(boolean b) {
        this.radioButton.setChecked(b);
        super.setChecked(b);
    }

    @Override
    public void setTitleText(String titleText) {
        this.radioButton.setText(titleText);
        super.setTitleText(titleText);
    }
}

