/*
 * Decompiled with CFR 0.152.
 */
package com.tokopedia.expandable;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.tokopedia.expandable.BaseExpandableOptionText;
import com.tokopedia.expandable.R;

public class ExpandableOptionArrow
extends BaseExpandableOptionText {
    private ImageView imageArrow;
    private Drawable imageUp;
    private Drawable imageDown;
    private View contentHeader;

    public ExpandableOptionArrow(Context context) {
        super(context);
    }

    public ExpandableOptionArrow(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ExpandableOptionArrow(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ExpandableOptionArrow(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected int getLayoutRes() {
        return R.layout.item_expandable_option_arrow;
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        TypedArray styledAttributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableOption);
        try {
            this.imageUp = styledAttributes.getDrawable(R.styleable.ExpandableOption_resource_image_arrow_up);
            this.imageDown = styledAttributes.getDrawable(R.styleable.ExpandableOption_resource_image_arrow_down);
        }
        finally {
            styledAttributes.recycle();
        }
        if (this.imageUp == null) {
            this.imageUp = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_arrow_up);
        }
        if (this.imageDown == null) {
            this.imageDown = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_arrow_down);
        }
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.contentHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ExpandableOptionArrow.this.toggle();
            }
        });
    }

    @Override
    public void setVisibleChildView(boolean b) {
        super.setVisibleChildView(b);
        if (b) {
            this.imageArrow.setImageDrawable(this.imageUp);
        } else {
            this.imageArrow.setImageDrawable(this.imageDown);
        }
    }

    @Override
    protected void initView(View view) {
        super.initView(view);
        this.imageArrow = (ImageView)view.findViewById(R.id.image_arrow);
        this.contentHeader = view.findViewById(R.id.content_header_option);
    }
}

