/*
 * Decompiled with CFR 0.152.
 */
package com.tokopedia.expandable;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.IdRes;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import com.tokopedia.expandable.RadioButtonExpandable;
import com.tokopedia.expandable.Utils;

public class RadioGroupExpandable
extends LinearLayout {
    public static final String CHECKED_ID = "CheckedId";
    public static final String PROTECT_FROM_CHECKED = "PROTECT_FROM_CHECKED";
    public static final String SUPER_STATE = "superState";
    private int checkedId = -1;
    private CompoundButton.OnCheckedChangeListener checkedChangeListener;
    private boolean protectFromCheckedChange = false;
    private OnCheckedChangeListener onCheckedChangeListener;
    private HierarchyChangeListener hierarcyChangeListener;

    public RadioGroupExpandable(Context context) {
        super(context);
        this.setOrientation(1);
        this.init();
    }

    public RadioGroupExpandable(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.checkedChangeListener = new CheckedStateTracker();
        this.hierarcyChangeListener = new HierarchyChangeListener();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.hierarcyChangeListener);
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.hierarcyChangeListener.onHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.checkedId != -1) {
            this.protectFromCheckedChange = true;
            this.setCheckedStateForView(this.checkedId, true);
            this.protectFromCheckedChange = false;
            this.setCheckedId(this.checkedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof RadioButtonExpandable) {
            RadioButtonExpandable button = (RadioButtonExpandable)child;
            this.setFlagRadioButton(button);
        }
        super.addView(child, index, params);
    }

    public void check(@IdRes int id2) {
        if (id2 != -1 && id2 == this.checkedId) {
            return;
        }
        if (this.checkedId != -1) {
            this.setCheckedStateForView(this.checkedId, false);
        }
        if (id2 != -1) {
            this.setCheckedStateForView(id2, true);
        }
        this.setCheckedId(id2);
    }

    private void setCheckedId(@IdRes int id2) {
        this.checkedId = id2;
        if (this.onCheckedChangeListener != null) {
            this.onCheckedChangeListener.onCheckedChanged(this, this.checkedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView != null && checkedView instanceof RadioButtonExpandable) {
            ((RadioButtonExpandable)checkedView).setChecked(checked);
        }
    }

    @IdRes
    public int getCheckedRadioButtonId() {
        return this.checkedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.onCheckedChangeListener = listener;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof RadioGroup.LayoutParams;
    }

    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public CharSequence getAccessibilityClassName() {
        return RadioGroup.class.getName();
    }

    private int generateId() {
        int id2 = Build.VERSION.SDK_INT < 17 ? Utils.generateViewId() : View.generateViewId();
        return id2;
    }

    private void setFlagRadioButton(RadioButtonExpandable radioButton) {
        if (radioButton.isChecked()) {
            this.protectFromCheckedChange = true;
            if (this.checkedId != -1) {
                this.setCheckedStateForView(this.checkedId, false);
            }
            this.protectFromCheckedChange = false;
            this.setCheckedId(radioButton.getId());
        }
    }

    private class HierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener;

        private HierarchyChangeListener() {
        }

        public void traverseTree(View view) {
            if (view instanceof RadioButtonExpandable) {
                int id2 = view.getId();
                if (id2 == -1) {
                    id2 = RadioGroupExpandable.this.generateId();
                    view.setId(id2);
                }
                RadioButtonExpandable radioButton = (RadioButtonExpandable)view;
                radioButton.addOnCheckedChangeListener(RadioGroupExpandable.this.checkedChangeListener);
                RadioGroupExpandable.this.setFlagRadioButton(radioButton);
            }
            if (!(view instanceof ViewGroup)) {
                return;
            }
            ViewGroup viewGroup = (ViewGroup)view;
            if (viewGroup.getChildCount() == 0) {
                return;
            }
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.traverseTree(viewGroup.getChildAt(i));
            }
        }

        public void onChildViewAdded(View parent, View child) {
            this.traverseTree(child);
            if (parent == RadioGroupExpandable.this && child instanceof RadioButtonExpandable) {
                int id2 = child.getId();
                if (id2 == -1) {
                    id2 = RadioGroupExpandable.this.generateId();
                    child.setId(id2);
                }
                RadioButtonExpandable radioButton = (RadioButtonExpandable)child;
                RadioGroupExpandable.this.setFlagRadioButton(radioButton);
            }
            if (this.onHierarchyChangeListener != null) {
                this.onHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == RadioGroupExpandable.this && child instanceof RadioButtonExpandable) {
                ((RadioButtonExpandable)child).clearOnCheckedChangeListener();
            }
            if (this.onHierarchyChangeListener != null) {
                this.onHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (RadioGroupExpandable.this.protectFromCheckedChange) {
                return;
            }
            RadioGroupExpandable.this.protectFromCheckedChange = true;
            if (RadioGroupExpandable.this.checkedId != -1) {
                RadioGroupExpandable.this.setCheckedStateForView(RadioGroupExpandable.this.checkedId, false);
            }
            RadioGroupExpandable.this.protectFromCheckedChange = false;
            int id2 = buttonView.getId();
            RadioGroupExpandable.this.setCheckedId(id2);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RadioGroupExpandable var1, @IdRes int var2);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, float initWeight) {
            super(w, h, initWeight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.hasValue(widthAttr) ? a.getLayoutDimension(widthAttr, "layout_width") : -2;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }
    }
}

