/*
 * Decompiled with CFR 0.152.
 */
package com.tokopedia.expandable;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v7.view.ContextThemeWrapper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.tokopedia.expandable.ExpandableViewLinear;
import com.tokopedia.expandable.R;

public abstract class BaseExpandableOption
extends LinearLayout {
    public static final String OPTION_CHECKED = "OPTION_CHECKED";
    public static final String TITLE_TEXT = "TITLE_TEXT";
    public static final String OPTION_ENABLED = "OPTION_ENABLED";
    public static final String SUPER_STATE = "superState";
    @StyleRes
    private int expandableLayoutTheme;
    protected ExpandableViewLinear expandableViewLinear;
    protected boolean optionChecked;
    protected boolean optionEnabled = true;
    protected String titleText = "";
    private ExpandableListener expandableListener;

    public BaseExpandableOption(Context context) {
        super(context);
        this.init();
    }

    public BaseExpandableOption(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
        this.init();
    }

    public BaseExpandableOption(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
        this.init();
    }

    @TargetApi(value=21)
    public BaseExpandableOption(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
        this.init();
    }

    public int getOrientation() {
        return 1;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childs = this.getChildCount();
        for (int i = 1; i < childs; ++i) {
            View childView = this.getChildAt(i);
            ((ViewGroup)childView.getParent()).removeView(childView);
            this.expandableViewLinear.addView(childView);
        }
    }

    public void toggle() {
        if (this.expandableViewLinear.getVisibility() == 8) {
            this.setVisibleChildView(true);
        } else {
            this.setVisibleChildView(false);
        }
    }

    public void setVisibleChildView(boolean b) {
        this.optionChecked = b;
        if (b) {
            this.expandableViewLinear.expand();
        } else {
            this.expandableViewLinear.collapse();
        }
        if (this.expandableListener != null) {
            this.expandableListener.onExpandViewChange(b);
        }
    }

    public void setExpand(boolean isChecked) {
        this.optionChecked = isChecked;
        this.setVisibleChildView(isChecked);
    }

    public boolean isExpanded() {
        return this.optionChecked;
    }

    protected void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    protected String getTitleText() {
        return this.titleText;
    }

    public void setExpandableListener(ExpandableListener expandableListener) {
        this.expandableListener = expandableListener;
    }

    protected void init(AttributeSet attributeSet) {
        TypedArray styledAttributes = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ExpandableOption);
        try {
            this.expandableLayoutTheme = styledAttributes.getResourceId(R.styleable.ExpandableOption_eo_theme, R.style.style_expandable_option_default);
            this.optionChecked = styledAttributes.getBoolean(R.styleable.ExpandableOption_eo_checked, false);
            this.titleText = styledAttributes.getString(R.styleable.ExpandableOption_eo_title);
            this.optionEnabled = styledAttributes.getBoolean(R.styleable.ExpandableOption_eo_enabled, true);
        }
        finally {
            styledAttributes.recycle();
        }
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.getContext(), this.getContext().getTheme());
        contextThemeWrapper.setTheme(this.expandableLayoutTheme);
    }

    protected void init() {
        View view = BaseExpandableOption.inflate((Context)this.getContext(), (int)this.getLayoutRes(), (ViewGroup)this);
        this.initView(view);
        this.expandableViewLinear = (ExpandableViewLinear)view.findViewById(R.id.expandable_view);
        this.setVisibleChildView(this.optionChecked);
        this.setEnabled(this.optionEnabled);
        this.setOrientation(1);
    }

    protected abstract void initView(View var1);

    protected abstract int getLayoutRes();

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(SUPER_STATE, super.onSaveInstanceState());
        bundle.putBoolean(OPTION_CHECKED, this.optionChecked);
        bundle.putString(TITLE_TEXT, this.titleText);
        bundle.putBoolean(OPTION_ENABLED, this.optionEnabled);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.optionChecked = bundle.getBoolean(OPTION_CHECKED);
            this.titleText = bundle.getString(TITLE_TEXT);
            this.optionEnabled = bundle.getBoolean(OPTION_ENABLED, this.optionEnabled);
            this.setExpand(this.optionChecked);
            this.setEnabled(this.optionEnabled);
            this.setTitleText(this.titleText);
            super.onRestoreInstanceState(bundle.getParcelable(SUPER_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.optionEnabled = enabled;
    }

    public static interface ExpandableListener {
        public void onExpandViewChange(boolean var1);
    }
}

