/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.Role;
import com.opentok.exception.InvalidArgumentException;
import java.util.List;

public class TokenOptions {
    private Role role;
    private long expireTime;
    private String data;
    private List<String> initialLayoutClassList;

    private TokenOptions(Builder builder) {
        this.role = builder.role != null ? builder.role : Role.PUBLISHER;
        this.expireTime = builder.expireTime;
        this.data = builder.data;
        this.initialLayoutClassList = builder.initialLayoutClassList;
    }

    public Role getRole() {
        return this.role;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public String getData() {
        return this.data;
    }

    public List<String> getInitialLayoutClassList() {
        return this.initialLayoutClassList;
    }

    public static class Builder {
        private Role role;
        private long expireTime = 0L;
        private String data;
        private List<String> initialLayoutClassList;

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder expireTime(long expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public Builder data(String data) throws InvalidArgumentException {
            if (data.length() > 1000) {
                throw new InvalidArgumentException("The given connection data is too long, limit is 1000 characters: " + data.length());
            }
            this.data = data;
            return this;
        }

        public Builder initialLayoutClassList(List<String> initialLayoutClassList) {
            this.initialLayoutClassList = initialLayoutClassList;
            return this;
        }

        public TokenOptions build() {
            return new TokenOptions(this);
        }
    }
}

