/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.Objects;

public class RenderProperties {
    private final URI url;
    private final int maxDuration;
    private final Resolution resolution;
    private final Properties properties;

    private RenderProperties(Builder builder) {
        this.url = Objects.requireNonNull(builder.url, "URL is required");
        this.resolution = builder.resolution;
        this.maxDuration = builder.maxDuration;
        this.properties = builder.properties;
    }

    public static Builder Builder() {
        return new Builder();
    }

    public URI url() {
        return this.url;
    }

    public int maxDuration() {
        return this.maxDuration;
    }

    public Resolution resolution() {
        return this.resolution;
    }

    public Properties properties() {
        return this.properties;
    }

    public static class Builder {
        private URI url;
        private int maxDuration = 7200;
        private Resolution resolution = Resolution.HD_HORIZONTAL;
        private Properties properties;

        public Builder url(String url) {
            return this.url(URI.create(url));
        }

        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        public Builder maxDuration(int maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public RenderProperties build() {
            return new RenderProperties(this);
        }
    }

    public static enum Resolution {
        SD_VERTICAL("480x640"),
        SD_HORIZONTAL("640x480"),
        HD_VERTICAL("720x1280"),
        HD_HORIZONTAL("1280x720");

        private final String value;

        private Resolution(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static class Properties {
        private final String name;

        public Properties(String name) {
            this.name = name;
            if (this.name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Name is required.");
            }
            if (name.length() > 200) {
                throw new IllegalArgumentException("Name '" + name + "' exceeds 200 characters.");
            }
        }

        public String name() {
            return this.name;
        }
    }
}

