/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.Archive;
import com.opentok.ArchiveLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ArchiveProperties {
    private String name = null;
    private String resolution = null;
    private boolean hasAudio;
    private boolean hasVideo;
    private Archive.OutputMode outputMode;
    private ArchiveLayout layout;

    private ArchiveProperties(Builder builder) {
        this.name = builder.name;
        this.resolution = builder.resolution;
        this.hasAudio = builder.hasAudio;
        this.hasVideo = builder.hasVideo;
        this.outputMode = builder.outputMode;
        this.layout = builder.layout;
    }

    public String name() {
        return this.name;
    }

    public String resolution() {
        return this.resolution;
    }

    public boolean hasVideo() {
        return this.hasVideo;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public Archive.OutputMode outputMode() {
        return this.outputMode;
    }

    public ArchiveLayout layout() {
        return this.layout;
    }

    public Map<String, Collection<String>> toMap() {
        ArrayList<String> valueList;
        HashMap<String, Collection<String>> params = new HashMap<String, Collection<String>>();
        if (this.name != null) {
            valueList = new ArrayList<String>();
            valueList.add(this.name);
            params.put("name", valueList);
        }
        if (this.resolution != null) {
            valueList = new ArrayList();
            valueList.add(this.resolution);
            params.put("resolution", valueList);
        }
        valueList = new ArrayList();
        valueList.add(Boolean.toString(this.hasAudio));
        params.put("hasAudio", valueList);
        valueList = new ArrayList();
        valueList.add(Boolean.toString(this.hasVideo));
        params.put("hasVideo", valueList);
        valueList = new ArrayList();
        valueList.add(this.outputMode.toString());
        params.put("outputMode", valueList);
        if (this.layout != null) {
            valueList = new ArrayList();
            valueList.add(this.layout.toString());
            params.put("layout", valueList);
        }
        return params;
    }

    public static class Builder {
        private String name = null;
        private String resolution = null;
        private boolean hasAudio = true;
        private boolean hasVideo = true;
        private Archive.OutputMode outputMode = Archive.OutputMode.COMPOSED;
        private ArchiveLayout layout = null;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder hasAudio(boolean hasAudio) {
            this.hasAudio = hasAudio;
            return this;
        }

        public Builder hasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            return this;
        }

        public Builder outputMode(Archive.OutputMode outputMode) {
            this.outputMode = outputMode;
            return this;
        }

        public Builder layout(ArchiveLayout layout) {
            this.layout = layout;
            return this;
        }

        public ArchiveProperties build() {
            return new ArchiveProperties(this);
        }
    }
}

