/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.Role;
import com.opentok.exception.InvalidArgumentException;

public class TokenOptions {
    private Role role;
    private double expireTime;
    private String data;

    private TokenOptions(Builder builder) {
        this.role = builder.role != null ? builder.role : Role.PUBLISHER;
        this.expireTime = builder.expireTime;
        this.data = builder.data;
    }

    public Role getRole() {
        return this.role;
    }

    public double getExpireTime() {
        return this.expireTime;
    }

    public String getData() {
        return this.data;
    }

    public static class Builder {
        private Role role;
        private double expireTime = 0.0;
        private String data;

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder expireTime(double expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public Builder data(String data) throws InvalidArgumentException {
            if (data.length() > 1000) {
                throw new InvalidArgumentException("The given connection data is too long, limit is 1000 characters: " + data.length());
            }
            this.data = data;
            return this;
        }

        public TokenOptions build() {
            return new TokenOptions(this);
        }
    }
}

