/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.toedter.spring.hateoas.jsonapi.AbstractJsonApiSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiRelationship;
import com.toedter.spring.hateoas.jsonapi.JsonApiResourceIdentifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.hateoas.Links;

class JsonApiRelationshipSerializer
extends AbstractJsonApiSerializer<JsonApiRelationship> {
    private final transient JsonApiConfiguration jsonApiConfiguration;

    public JsonApiRelationshipSerializer(JsonApiConfiguration jsonApiConfiguration) {
        super(JsonApiRelationship.class, false);
        this.jsonApiConfiguration = jsonApiConfiguration;
    }

    public void serialize(JsonApiRelationship value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        List<JsonApiResourceIdentifier> data = value.getData();
        if (data != null) {
            data = data instanceof Collection ? value.toJsonApiResourceCollection((Collection)data, this.jsonApiConfiguration) : value.toJsonApiResource(data, this.jsonApiConfiguration);
        }
        if (data == null && value.getLinks() == null && value.getMeta() == null) {
            provider.findValueSerializer(JsonApiNullDataRelationshipForSerialization.class).serialize((Object)new JsonApiNullDataRelationshipForSerialization(), gen, provider);
        } else {
            JsonApiRelationshipForSerialization jsonApiRelationship = new JsonApiRelationshipForSerialization(data, value.getLinks(), value.getMeta());
            provider.findValueSerializer(JsonApiRelationshipForSerialization.class).serialize((Object)jsonApiRelationship, gen, provider);
        }
    }

    private static class JsonApiNullDataRelationshipForSerialization {
        private final Object data = null;

        private JsonApiNullDataRelationshipForSerialization() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Object getData() {
            return this.data;
        }
    }

    private static class JsonApiRelationshipForSerialization {
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private final Object data;
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private final Links links;
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private final Map<String, Object> meta;

        public JsonApiRelationshipForSerialization(@Nullable Object data, @Nullable Links links, @Nullable Map<String, Object> meta) {
            this.data = data;
            this.links = links;
            this.meta = meta;
        }

        @Nullable
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Object getData() {
            return this.data;
        }

        @Nullable
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Links getLinks() {
            return this.links;
        }

        @Nullable
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }
    }
}

