/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.toedter.spring.hateoas.jsonapi.AbstractJsonApiModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiDocument;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;

class JsonApiPagedModelDeserializer
extends AbstractJsonApiModelDeserializer<PagedModel<?>>
implements ContextualDeserializer {
    public JsonApiPagedModelDeserializer(JsonApiConfiguration jsonApiConfiguration) {
        super(jsonApiConfiguration);
    }

    protected JsonApiPagedModelDeserializer(JavaType contentType, JsonApiConfiguration jsonApiConfiguration) {
        super(contentType, jsonApiConfiguration);
    }

    @Override
    protected PagedModel<?> convertToRepresentationModel(List<Object> resources, JsonApiDocument doc) {
        Map pageMeta;
        Links links = doc.getLinks();
        PagedModel.PageMetadata pageMetadata = null;
        Map<String, Object> meta = doc.getMeta();
        if (meta != null && (pageMeta = (Map)meta.get("page")) != null) {
            pageMetadata = new PagedModel.PageMetadata(((Number)pageMeta.get("size")).longValue(), ((Number)pageMeta.get("number")).longValue(), ((Number)pageMeta.get("totalElements")).longValue(), ((Number)pageMeta.get("totalPages")).longValue());
        }
        if (links == null) {
            links = Links.NONE;
        }
        return PagedModel.of(resources, pageMetadata, (Iterable)links);
    }

    @Override
    protected JsonDeserializer<?> createJsonDeserializer(JavaType type) {
        return new JsonApiPagedModelDeserializer(type, this.jsonApiConfiguration);
    }
}

