/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.toedter.spring.hateoas.jsonapi.JsonApiModel;
import com.toedter.spring.hateoas.jsonapi.JsonApiRelationship;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JsonApiModelBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonApiModelBuilder.class);
    private static final String RELATIONSHIP_NAME_MUST_NOT_BE_NULL = "relationship name must not be null!";
    private static final String RELATED = "related";
    private static final String PAGE = "page";
    private static final String PAGE_NUMBER = "number";
    private static final String PAGE_SIZE = "size";
    private static final String PAGE_TOTAL_ELEMENTS = "totalElements";
    private static final String PAGE_TOTAL_PAGES = "totalPages";
    private final HashMap<String, JsonApiRelationship> relationships = new HashMap();
    private final HashMap<String, Collection<String>> sparseFieldsets = new HashMap();
    private final List<RepresentationModel<?>> included = new ArrayList();
    private final Map<String, Object> meta = new LinkedHashMap<String, Object>();
    private RepresentationModel<?> model;
    private Links links = Links.NONE;

    private JsonApiModelBuilder() {
    }

    public JsonApiModelBuilder model(RepresentationModel<?> model) {
        Assert.notNull(model, (String)"RepresentationModel must not be null!");
        if (this.model != null) {
            throw new IllegalStateException("Model object already set!");
        }
        this.model = model;
        this.links((Iterable<Link>)model.getLinks());
        return this;
    }

    public JsonApiModelBuilder model(Object object) {
        return this.model((RepresentationModel<?>)EntityModel.of((Object)object));
    }

    public JsonApiModelBuilder link(Link link) {
        this.links = this.links.and(new Link[]{link});
        return this;
    }

    public JsonApiModelBuilder link(String href, LinkRelation relation) {
        return this.link(Link.of((String)href, (LinkRelation)relation));
    }

    public JsonApiModelBuilder links(Iterable<Link> links) {
        this.links = this.links.and(links);
        return this;
    }

    public JsonApiModelBuilder relationship(String name, @Nullable Object dataObject) {
        Assert.notNull((Object)name, (String)RELATIONSHIP_NAME_MUST_NOT_BE_NULL);
        JsonApiRelationship jsonApiRelationship = this.addDataObject(this.relationships.get(name), dataObject, null);
        this.relationships.put(name, jsonApiRelationship);
        return this;
    }

    public JsonApiModelBuilder relationship(String name, Collection<?> collection) {
        Assert.notNull((Object)name, (String)RELATIONSHIP_NAME_MUST_NOT_BE_NULL);
        Assert.notNull(collection, (String)"Relationship data collection must not be null!");
        JsonApiRelationship jsonApiRelationship = this.addDataCollection(this.relationships.get(name), collection);
        this.relationships.put(name, jsonApiRelationship);
        return this;
    }

    public JsonApiModelBuilder relationship(String name, EntityModel<?> entityModel) {
        Assert.notNull(entityModel, (String)"EntityModel must not be null!");
        Object content = entityModel.getContent();
        Assert.notNull((Object)content, (String)"Content of EntityModel must not be null!");
        return this.relationship(name, content);
    }

    public JsonApiModelBuilder relationship(String name, @Nullable EntityModel<?> entityModel, @Nullable String selfLink, @Nullable String relatedLink) {
        Assert.notNull((Object)name, (String)"Relationship name must not be null!");
        if (entityModel == null && selfLink == null && relatedLink == null) {
            throw new IllegalArgumentException("At least one of entityModel, selfLink, and relatedLink must not be null!");
        }
        JsonApiRelationship jsonApiRelationship = null;
        if (entityModel != null) {
            Object content = entityModel.getContent();
            Assert.notNull((Object)content, (String)"Content of EntityModel must not be null!");
            jsonApiRelationship = this.addDataObject(this.relationships.get(name), content, null);
        }
        if (selfLink != null || relatedLink != null) {
            jsonApiRelationship = this.replaceLinks(jsonApiRelationship, selfLink, relatedLink, null);
        }
        this.relationships.put(name, jsonApiRelationship);
        return this;
    }

    public JsonApiModelBuilder relationship(String name, Map<String, Object> meta) {
        Assert.notNull((Object)name, (String)RELATIONSHIP_NAME_MUST_NOT_BE_NULL);
        Assert.notNull(meta, (String)"relationship meta object must not be null!");
        JsonApiRelationship jsonApiRelationship = this.relationships.get(name);
        jsonApiRelationship = jsonApiRelationship == null ? JsonApiRelationship.of(meta) : jsonApiRelationship.withMeta(meta);
        this.relationships.put(name, jsonApiRelationship);
        return this;
    }

    public JsonApiModelBuilder relationship(String name, Object dataObject, Map<String, Object> resourceIdentifierMeta) {
        Assert.notNull((Object)name, (String)RELATIONSHIP_NAME_MUST_NOT_BE_NULL);
        Assert.notNull((Object)dataObject, (String)"Relationship data object must not be null!");
        JsonApiRelationship jsonApiRelationship = this.addDataObject(this.relationships.get(name), dataObject, resourceIdentifierMeta);
        this.relationships.put(name, jsonApiRelationship);
        return this;
    }

    public JsonApiModelBuilder relationship(String name, @Nullable String selfLink, @Nullable String relatedLink, @Nullable Links otherLinks) {
        Assert.notNull((Object)name, (String)RELATIONSHIP_NAME_MUST_NOT_BE_NULL);
        JsonApiRelationship jsonApiRelationship = this.replaceLinks(this.relationships.get(name), selfLink, relatedLink, otherLinks);
        this.relationships.put(name, jsonApiRelationship);
        return this;
    }

    public JsonApiModelBuilder relationshipWithDataArray(String name) {
        Assert.notNull((Object)name, (String)RELATIONSHIP_NAME_MUST_NOT_BE_NULL);
        JsonApiRelationship jsonApiRelationship = this.relationships.get(name);
        if (jsonApiRelationship == null) {
            jsonApiRelationship = new JsonApiRelationship(null, null, null, null);
        }
        jsonApiRelationship = jsonApiRelationship.isAlwaysSerializedWithDataArray();
        this.relationships.put(name, jsonApiRelationship);
        return this;
    }

    private JsonApiRelationship replaceLinks(@Nullable JsonApiRelationship jsonApiRelationship, @Nullable String selfLink, @Nullable String relatedLink, @Nullable Links otherLinks) {
        Links relationshipLinks = Links.NONE;
        if (otherLinks != null) {
            relationshipLinks = otherLinks;
        }
        if (selfLink != null && selfLink.trim().length() != 0) {
            relationshipLinks = relationshipLinks.and(new Link[]{Link.of((String)selfLink)});
        }
        if (relatedLink != null && relatedLink.trim().length() != 0) {
            relationshipLinks = relationshipLinks.and(new Link[]{Link.of((String)relatedLink).withRel(RELATED)});
        }
        if (relationshipLinks.isEmpty() || !relationshipLinks.hasLink("self") && !relationshipLinks.hasLink(RELATED)) {
            throw new IllegalArgumentException("JSON:API relationship links must contain a \"self\" link or a \"related\" link!");
        }
        JsonApiRelationship newRelationship = jsonApiRelationship == null ? JsonApiRelationship.of(relationshipLinks) : jsonApiRelationship.withLinks(relationshipLinks);
        return newRelationship;
    }

    private JsonApiRelationship addDataObject(@Nullable JsonApiRelationship jsonApiRelationship, @Nullable Object dataObject, @Nullable Map<String, Object> resourceIdentifierMeta) {
        JsonApiRelationship newRelationship = jsonApiRelationship == null ? JsonApiRelationship.of(dataObject, resourceIdentifierMeta) : jsonApiRelationship.addDataObject(dataObject, resourceIdentifierMeta);
        return newRelationship;
    }

    private JsonApiRelationship addDataCollection(@Nullable JsonApiRelationship jsonApiRelationship, Collection<?> collection) {
        JsonApiRelationship newRelationship = jsonApiRelationship == null ? JsonApiRelationship.of(collection) : jsonApiRelationship.addDataCollection(collection);
        return newRelationship;
    }

    public JsonApiModelBuilder included(RepresentationModel<?> representationModel) {
        this.included.add(representationModel);
        return this;
    }

    public JsonApiModelBuilder included(Object object) {
        return this.included((RepresentationModel<?>)EntityModel.of((Object)object));
    }

    public JsonApiModelBuilder included(Collection<?> collection) {
        Assert.notNull(collection, (String)"included data collection must not be null!");
        for (Object object : collection) {
            if (object instanceof RepresentationModel) {
                this.included((RepresentationModel)object);
                continue;
            }
            this.included(object);
        }
        return this;
    }

    public JsonApiModelBuilder meta(String key, Object value) {
        this.meta.put(key, value);
        return this;
    }

    public JsonApiModelBuilder pageMeta() {
        PagedModel.PageMetadata metadata = this.getPageMetadata();
        long pageNumber = metadata.getNumber();
        long pageSize = metadata.getSize();
        long totalElements = metadata.getTotalElements();
        long totalPages = metadata.getTotalPages();
        LinkedHashMap<String, Long> metaObject = new LinkedHashMap<String, Long>();
        metaObject.put(PAGE_SIZE, pageSize);
        metaObject.put(PAGE_TOTAL_ELEMENTS, totalElements);
        metaObject.put(PAGE_TOTAL_PAGES, totalPages);
        metaObject.put(PAGE_NUMBER, pageNumber);
        this.meta.put(PAGE, metaObject);
        return this;
    }

    public JsonApiModelBuilder pageLinks(String linkBase) {
        return this.pageLinks(linkBase, "page[number]", "page[size]");
    }

    public JsonApiModelBuilder pageLinks(String linkBase, String pageNumberRequestParam, String pageSizeRequestParam) {
        Assert.notNull((Object)linkBase, (String)"link base for paging must not be null!");
        Assert.notNull((Object)pageNumberRequestParam, (String)"page number request parameter must not be null!");
        Assert.notNull((Object)pageSizeRequestParam, (String)"page size request parameter must not be null!");
        PagedModel.PageMetadata metadata = this.getPageMetadata();
        long pageNumber = metadata.getNumber();
        long pageSize = metadata.getSize();
        long totalPages = metadata.getTotalPages();
        ArrayList<Link> paginationLinks = new ArrayList<Link>();
        String paramStart = "?";
        try {
            URL url = new URL(linkBase);
            String query = url.getQuery();
            if (query != null) {
                paramStart = "&";
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("linkBase parameter must be a valid URL.");
        }
        if (pageNumber > 0L) {
            Link firstLink = Link.of((String)(linkBase + paramStart + pageNumberRequestParam + "=0&" + pageSizeRequestParam + "=" + pageSize)).withRel(IanaLinkRelations.FIRST);
            paginationLinks.add(firstLink);
            Link prevLink = Link.of((String)(linkBase + paramStart + pageNumberRequestParam + "=" + (pageNumber - 1L) + "&" + pageSizeRequestParam + "=" + pageSize)).withRel(IanaLinkRelations.PREV);
            paginationLinks.add(prevLink);
        }
        if (pageNumber < totalPages - 1L) {
            Link nextLink = Link.of((String)(linkBase + paramStart + pageNumberRequestParam + "=" + (pageNumber + 1L) + "&" + pageSizeRequestParam + "=" + pageSize)).withRel(IanaLinkRelations.NEXT);
            paginationLinks.add(nextLink);
            Link lastLink = Link.of((String)(linkBase + paramStart + pageNumberRequestParam + "=" + (totalPages - 1L) + "&" + pageSizeRequestParam + "=" + pageSize)).withRel(IanaLinkRelations.LAST);
            paginationLinks.add(lastLink);
        }
        this.links = this.links.and(paginationLinks);
        return this;
    }

    public JsonApiModelBuilder fields(String jsonapiType, String ... fields) {
        ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(fields));
        this.sparseFieldsets.put(jsonapiType, fieldList);
        return this;
    }

    public RepresentationModel<?> build() {
        for (JsonApiRelationship jsonApiRelationship : this.relationships.values()) {
            if (jsonApiRelationship.isValid()) continue;
            throw new IllegalStateException("Cannot build representation model: JSON:API relationship validation error for: " + jsonApiRelationship);
        }
        return new JsonApiModel(this.model, this.relationships, this.included, this.meta, this.links, this.sparseFieldsets);
    }

    public static JsonApiModelBuilder jsonApiModel() {
        return new JsonApiModelBuilder();
    }

    private PagedModel.PageMetadata getPageMetadata() {
        if (this.model == null) {
            throw new IllegalStateException("Model object (PagedModel) must be set.");
        }
        if (!(this.model instanceof PagedModel)) {
            throw new IllegalStateException("Model object must be a PagedModel.");
        }
        PagedModel.PageMetadata metadata = ((PagedModel)this.model).getMetadata();
        if (metadata == null) {
            throw new IllegalStateException("PagedModel object must contain page metadata.");
        }
        return metadata;
    }
}

