/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiDocument;
import com.toedter.spring.hateoas.jsonapi.JsonApiMediaTypeConfiguration;
import com.toedter.spring.hateoas.jsonapi.MediaTypes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.http.MediaType;

public class JsonApiLinkDiscoverer
implements LinkDiscoverer {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonApiLinkDiscoverer() {
        new JsonApiMediaTypeConfiguration(null, null).configureObjectMapper(this.mapper, new JsonApiConfiguration());
    }

    public Optional<Link> findLinkWithRel(LinkRelation rel, String representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).findFirst();
    }

    public Optional<Link> findLinkWithRel(LinkRelation rel, InputStream representation) {
        return this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).findFirst();
    }

    public Links findLinksWithRel(LinkRelation rel, String representation) {
        return (Links)this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).collect(Links.collector());
    }

    public Links findLinksWithRel(LinkRelation rel, InputStream representation) {
        return (Links)this.getLinks(representation).stream().filter(it -> it.hasRel(rel)).collect(Links.collector());
    }

    public boolean supports(MediaType delimiter) {
        return delimiter.isCompatibleWith(MediaTypes.JSON_API);
    }

    private Links getLinks(String json) {
        try {
            JsonApiDocument jsonApiDocument = (JsonApiDocument)this.mapper.readValue(json, JsonApiDocument.class);
            Links links = jsonApiDocument.getLinks();
            if (links != null) {
                return links;
            }
            return Links.NONE;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot get links from JSON", e);
        }
    }

    private Links getLinks(InputStream stream) {
        try {
            JsonApiDocument jsonApiDocument = (JsonApiDocument)this.mapper.readValue(stream, JsonApiDocument.class);
            Links links = jsonApiDocument.getLinks();
            if (links != null) {
                return links;
            }
            return Links.NONE;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot get links from InputStream", e);
        }
    }
}

