/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.toedter.spring.hateoas.jsonapi.JsonApiCollectionModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiCollectionModelSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiEntityModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiEntityModelSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiPagedModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiPagedModelSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiRelationshipSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiRepresentationModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiRepresentationModelSerializer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.lang.Nullable;

class JsonApiHandlerInstantiator
extends HandlerInstantiator {
    private final Map<Class<?>, Object> serializers = new HashMap();
    @Nullable
    private final AutowireCapableBeanFactory beanFactory;

    public JsonApiHandlerInstantiator(JsonApiConfiguration jsonApiConfiguration, @Nullable AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.serializers.put(JsonApiRepresentationModelSerializer.class, (Object)new JsonApiRepresentationModelSerializer(jsonApiConfiguration));
        this.serializers.put(JsonApiEntityModelSerializer.class, (Object)new JsonApiEntityModelSerializer(jsonApiConfiguration));
        this.serializers.put(JsonApiCollectionModelSerializer.class, (Object)new JsonApiCollectionModelSerializer(jsonApiConfiguration));
        this.serializers.put(JsonApiPagedModelSerializer.class, (Object)new JsonApiPagedModelSerializer(jsonApiConfiguration));
        this.serializers.put(JsonApiRelationshipSerializer.class, (Object)new JsonApiRelationshipSerializer(jsonApiConfiguration));
        this.serializers.put(JsonApiRepresentationModelDeserializer.class, (Object)new JsonApiRepresentationModelDeserializer(jsonApiConfiguration));
        this.serializers.put(JsonApiEntityModelDeserializer.class, (Object)new JsonApiEntityModelDeserializer(jsonApiConfiguration));
        this.serializers.put(JsonApiCollectionModelDeserializer.class, (Object)new JsonApiCollectionModelDeserializer(jsonApiConfiguration));
        this.serializers.put(JsonApiPagedModelDeserializer.class, (Object)new JsonApiPagedModelDeserializer(jsonApiConfiguration));
    }

    public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
        return (JsonDeserializer)this.findInstance(deserClass);
    }

    public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
        return (KeyDeserializer)this.findInstance(keyDeserClass);
    }

    public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
        return (JsonSerializer)this.findInstance(serClass);
    }

    public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
        return (TypeResolverBuilder)this.findInstance(builderClass);
    }

    public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
        return (TypeIdResolver)this.findInstance(resolverClass);
    }

    private Object findInstance(Class<?> type) {
        Object result = this.serializers.get(type);
        if (result != null) {
            return result;
        }
        if (this.beanFactory != null) {
            return this.beanFactory.createBean(type);
        }
        return BeanUtils.instantiateClass(type);
    }
}

