/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.mediatype.ConfiguredAffordance;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;

class JsonApiAffordanceModel
extends AffordanceModel {
    private static final Set<HttpMethod> ENTITY_ALTERING_METHODS = Set.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private final List<PropertyData> inputProperties = this.determineAffordanceInputs();
    private final List<PropertyData> queryProperties = this.determineQueryProperties();

    JsonApiAffordanceModel(ConfiguredAffordance configured) {
        super(configured.getNameOrDefault(), configured.getTarget(), configured.getMethod(), configured.getInputMetadata(), configured.getQueryParameters(), configured.getOutputMetadata());
    }

    private List<PropertyData> determineAffordanceInputs() {
        if (!ENTITY_ALTERING_METHODS.contains(this.getHttpMethod())) {
            return Collections.emptyList();
        }
        return this.getInput().stream().map(propertyMetadata -> new PropertyData().withName(propertyMetadata.getName()).withType(propertyMetadata.getInputType()).withRequired(propertyMetadata.isRequired())).collect(Collectors.toList());
    }

    private List<PropertyData> determineQueryProperties() {
        if (!this.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return Collections.emptyList();
        }
        if (this.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return this.getQueryMethodParameters().stream().map(queryParameter -> new PropertyData().withName(queryParameter.getName()).withType("")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<PropertyData> getInputProperties() {
        return this.inputProperties;
    }

    public List<PropertyData> getQueryProperties() {
        return this.queryProperties;
    }

    @JsonIgnore
    public AffordanceModel.InputPayloadMetadata getInput() {
        return super.getInput();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonApiAffordanceModel)) {
            return false;
        }
        JsonApiAffordanceModel other = (JsonApiAffordanceModel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<PropertyData> this$inputProperties = this.getInputProperties();
        List<PropertyData> other$inputProperties = other.getInputProperties();
        if (this$inputProperties == null ? other$inputProperties != null : !((Object)this$inputProperties).equals(other$inputProperties)) {
            return false;
        }
        List<PropertyData> this$queryProperties = this.getQueryProperties();
        List<PropertyData> other$queryProperties = other.getQueryProperties();
        return !(this$queryProperties == null ? other$queryProperties != null : !((Object)this$queryProperties).equals(other$queryProperties));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonApiAffordanceModel;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<PropertyData> $inputProperties = this.getInputProperties();
        result = result * 59 + ($inputProperties == null ? 43 : ((Object)$inputProperties).hashCode());
        List<PropertyData> $queryProperties = this.getQueryProperties();
        result = result * 59 + ($queryProperties == null ? 43 : ((Object)$queryProperties).hashCode());
        return result;
    }

    static final class PropertyData {
        @Nullable
        private final String name;
        @Nullable
        private final String type;
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private final boolean required;

        PropertyData() {
            this.name = null;
            this.type = null;
            this.required = false;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyData)) {
                return false;
            }
            PropertyData other = (PropertyData)o;
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequired() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "JsonApiAffordanceModel.PropertyData(name=" + this.getName() + ", type=" + this.getType() + ", required=" + this.isRequired() + ")";
        }

        @Nullable
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }

        @Nullable
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isRequired() {
            return this.required;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PropertyData(@Nullable String name, @Nullable String type, boolean required) {
            this.name = name;
            this.type = type;
            this.required = required;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PropertyData withName(@Nullable String name) {
            return this.name == name ? this : new PropertyData(name, this.type, this.required);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PropertyData withType(@Nullable String type) {
            return this.type == type ? this : new PropertyData(this.name, type, this.required);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PropertyData withRequired(boolean required) {
            return this.required == required ? this : new PropertyData(this.name, this.type, required);
        }
    }
}

