/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.toedter.spring.hateoas.jsonapi.AbstractJsonApiSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiData;
import com.toedter.spring.hateoas.jsonapi.JsonApiDocument;
import com.toedter.spring.hateoas.jsonapi.JsonApiModel;
import com.toedter.spring.hateoas.jsonapi.JsonApiModelBuilder;
import com.toedter.spring.hateoas.jsonapi.JsonApiObject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import lombok.Generated;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.lang.Nullable;

abstract class AbstractJsonApiModelSerializer<T extends RepresentationModel<?>>
extends AbstractJsonApiSerializer<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = Logger.getLogger(AbstractJsonApiModelSerializer.class.getName());
    private final transient JsonApiConfiguration jsonApiConfiguration;
    private final ObjectMapper objectMapper;

    protected AbstractJsonApiModelSerializer(Class<?> t, JsonApiConfiguration jsonApiConfiguration) {
        super(t, false);
        this.jsonApiConfiguration = jsonApiConfiguration;
        this.objectMapper = new ObjectMapper();
        jsonApiConfiguration.customize(this.objectMapper);
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Map<String, Object> meta;
        JsonApiModel jsonApiModel;
        Map<String, Object> metaData;
        JsonApiObject jsonApiObject;
        JsonApiModel jsonApiModel2;
        List<JsonApiData> data;
        CollectionModel collectionModel = null;
        if (value instanceof JsonApiModel) {
            JsonApiModel jsonApiModel3 = (JsonApiModel)((Object)value);
            RepresentationModel<?> content = jsonApiModel3.getContent();
            if (content instanceof CollectionModel) {
                CollectionModel collectionModelContent;
                collectionModel = collectionModelContent = (CollectionModel)content;
            }
        } else if (value instanceof CollectionModel) {
            CollectionModel collectionModelContent;
            collectionModel = collectionModelContent = (CollectionModel)value;
        }
        Map<String, Object> embeddedMeta = null;
        if (collectionModel != null) {
            data = JsonApiData.extractCollectionContent(collectionModel, this.objectMapper, this.jsonApiConfiguration, null, false);
        } else if (value instanceof JsonApiModel && (jsonApiModel2 = (JsonApiModel)((Object)value)).getContent() != null && jsonApiModel2.getContent() instanceof JsonApiModel) {
            JsonApiModel content = (JsonApiModel)((JsonApiModel)((Object)value)).getContent();
            embeddedMeta = Objects.requireNonNull(content).getMetaData();
            Optional<JsonApiData> jsonApiData = JsonApiData.extractContent((Object)content, true, this.objectMapper, this.jsonApiConfiguration, null);
            data = jsonApiData.orElse(null);
        } else {
            if (value instanceof JsonApiModel) {
                JsonApiModel jsonApiModel4 = (JsonApiModel)((Object)value);
                embeddedMeta = jsonApiModel4.getMetaData();
            }
            Optional<JsonApiData> jsonApiData = JsonApiData.extractContent(value, true, this.objectMapper, this.jsonApiConfiguration, null);
            data = jsonApiData.orElse(null);
        }
        JsonApiDocument doc = new JsonApiDocument().withData(data).withLinks(this.getLinksOrNull((RepresentationModel<?>)value)).withIncluded(this.getIncluded((RepresentationModel<?>)value));
        if (this.jsonApiConfiguration.isJsonApiVersionRendered()) {
            doc = doc.withJsonapi(new JsonApiObject(true));
        }
        if ((jsonApiObject = this.jsonApiConfiguration.getJsonApiObject()) != null && (jsonApiObject.getVersion() != null || jsonApiObject.getExt() != null || jsonApiObject.getProfile() != null || jsonApiObject.getMeta() != null)) {
            doc = doc.withJsonapi(jsonApiObject);
        }
        if (this.jsonApiConfiguration.isPageMetaAutomaticallyCreated() && collectionModel instanceof PagedModel) {
            JsonApiModel model = (JsonApiModel)JsonApiModelBuilder.jsonApiModel().model((RepresentationModel<?>)collectionModel).pageMeta().build();
            metaData = model.getMetaData();
            doc = doc.withMeta(metaData);
        }
        if (value instanceof JsonApiModel && (embeddedMeta != (metaData = (jsonApiModel = (JsonApiModel)((Object)value)).getMetaData()) || data == null)) {
            Map<String, Object> meta2 = doc.getMeta();
            if (meta2 == null) {
                doc = doc.withMeta(metaData);
            } else {
                for (Map.Entry<String, Object> entry : metaData.entrySet()) {
                    meta2.put(entry.getKey().toString(), entry.getValue());
                }
            }
        }
        if ((meta = doc.getMeta()) != null && !meta.isEmpty() && doc.getData() == null) {
            JsonApiDocumentWithoutSerializedData documentWithoutSerializedData = new JsonApiDocumentWithoutSerializedData(doc);
            provider.findValueSerializer(JsonApiDocumentWithoutSerializedData.class).serialize((Object)documentWithoutSerializedData, gen, provider);
        } else {
            provider.findValueSerializer(JsonApiDocument.class).serialize((Object)doc, gen, provider);
        }
    }

    @Nullable
    private Links getLinksOrNull(RepresentationModel<?> representationModel) {
        Links links = representationModel.getLinks();
        if (links.isEmpty()) {
            links = null;
        }
        if (this.jsonApiConfiguration.isJsonApiCompliantLinks() && links != null) {
            Links validJsonApiLinks = Links.NONE;
            for (Link link : links) {
                if (!validJsonApiLinks.hasLink(link.getRel()) && (link.hasRel("self") || link.hasRel("related") || link.hasRel("describedby") || link.hasRel("first") || link.hasRel("last") || link.hasRel("prev") || link.hasRel("next"))) {
                    validJsonApiLinks = validJsonApiLinks.and(new Link[]{link});
                    continue;
                }
                log.warning("removed invalid JSON:API top-level link: " + link.getRel());
            }
            links = validJsonApiLinks;
        }
        return links;
    }

    @Nullable
    private List<JsonApiData> getIncluded(RepresentationModel<?> representationModel) {
        if (representationModel instanceof JsonApiModel) {
            JsonApiModel jsonApiModel = (JsonApiModel)representationModel;
            List<RepresentationModel<?>> includedEntities = jsonApiModel.getIncludedEntities();
            CollectionModel collectionModel = CollectionModel.of(includedEntities);
            return JsonApiData.extractCollectionContent(collectionModel, this.objectMapper, this.jsonApiConfiguration, jsonApiModel.getSparseFieldsets(), true);
        }
        return null;
    }

    private static class JsonApiDocumentWithoutSerializedData
    extends JsonApiDocument {
        JsonApiDocumentWithoutSerializedData(JsonApiDocument jsonApiDocument) {
            super(jsonApiDocument.getJsonapi(), null, jsonApiDocument.getMeta(), jsonApiDocument.getErrors(), jsonApiDocument.getLinks(), jsonApiDocument.getIncluded());
        }

        @Override
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @Nullable
        public Object getData() {
            return null;
        }
    }
}

