package com.tocea.easycoverage.framework.providers;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.tocea.easycoverage.framework.api.IInstanceProvider;

public class SpringProvider implements IInstanceProvider {

	private static final Logger						LOGGER		= LoggerFactory
																		.getLogger(SpringProvider.class);

	private final ConfigurableApplicationContext	context;
	private final Map<Class<?>, String>				beanNames	= new HashMap<Class<?>, String>();

	public SpringProvider(final String... configLocations) {
		context = new ClassPathXmlApplicationContext(configLocations);
	}

	public SpringProvider(final ConfigurableApplicationContext context) {
		this.context = context;
	}

	public <T> T getInstance(final Class<T> clazz) {
		context.refresh();
		T instance = null;
		if (beanNames.containsKey(clazz)) {
			try {
				instance = context.getBean(beanNames.get(clazz), clazz);
			} catch (final BeansException e) {
				LOGGER.debug("Exception while trying to get bean {}: {}.",
						beanNames.get(clazz), e.getClass().getName());
			}
		}
		else {
			try {
				instance = context.getBean(clazz);
			} catch (final BeansException e) {
				LOGGER.debug(
						"Exception while trying to get bean of type {}: {}.",
						clazz.getName(), e.getClass().getName());
			}
		}
		return instance;
	}

	public <T> boolean canProvide(final Class<T> clazz) {
		return getInstance(clazz) != null;
	}

	public void addBean(final String beanName, final Class<?> clazz) {
		beanNames.put(clazz, beanName);
	}

}
