/*
 * Decompiled with CFR 0.152.
 */
package com.tocea.easycoverage.framework.providers;

import com.tocea.easycoverage.framework.api.IInstanceProvider;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringProvider
implements IInstanceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringProvider.class);
    private final ConfigurableApplicationContext context;
    private final Map<Class<?>, String> beanNames = new HashMap();

    public SpringProvider(String ... configLocations) {
        this.context = new ClassPathXmlApplicationContext(configLocations);
    }

    public SpringProvider(ConfigurableApplicationContext context) {
        this.context = context;
    }

    public <T> T getInstance(Class<T> clazz) {
        this.context.refresh();
        Object instance = null;
        if (this.beanNames.containsKey(clazz)) {
            try {
                instance = this.context.getBean(this.beanNames.get(clazz), clazz);
            }
            catch (BeansException e) {
                LOGGER.debug("Exception while trying to get bean {}: {}.", (Object)this.beanNames.get(clazz), (Object)((Object)((Object)e)).getClass().getName());
            }
        } else {
            try {
                instance = this.context.getBean(clazz);
            }
            catch (BeansException e) {
                LOGGER.debug("Exception while trying to get bean of type {}: {}.", (Object)clazz.getName(), (Object)((Object)((Object)e)).getClass().getName());
            }
        }
        return (T)instance;
    }

    public <T> boolean canProvide(Class<T> clazz) {
        return this.getInstance(clazz) != null;
    }

    public void addBean(String beanName, Class<?> clazz) {
        this.beanNames.put(clazz, beanName);
    }
}

