/*
 * Decompiled with CFR 0.152.
 */
package com.to.aboomy.statusbar_lib;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.to.aboomy.statusbar_lib.R;
import com.to.aboomy.statusbar_lib.StatusBarView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtil {
    public static boolean setStatusBarColor(Activity activity, @ColorInt int color) {
        return StatusBarUtil.setStatusBarColor(activity, color, 0);
    }

    public static boolean setStatusBarColor(Activity activity, @ColorInt int color, @IntRange(from=0L, to=255L) int statusBarAlpha) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            int calculateStatusColor = StatusBarUtil.calculateStatusColor(color, statusBarAlpha);
            window.setStatusBarColor(calculateStatusColor);
            return StatusBarUtil.immersiveStatusBarNeedDark(activity, calculateStatusColor);
        }
        return false;
    }

    public static boolean transparencyBar(Activity activity, boolean isNeedDark) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
            return StatusBarUtil.immersiveStatusBarNeedDark(activity, isNeedDark);
        }
        return false;
    }

    public static boolean drawerLayoutForColor(Activity activity, @ColorInt int color, DrawerLayout drawerLayout) {
        return StatusBarUtil.drawerLayoutForColor(activity, color, drawerLayout, 0, true);
    }

    public static boolean drawerLayoutForColor(Activity activity, @ColorInt int color, DrawerLayout drawerLayout, int statusBarAlpha, boolean hideStatusBarBackground) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
        View fakeStatusBarView = contentLayout.findViewById(R.id.view_status_bar);
        if (fakeStatusBarView != null) {
            if (fakeStatusBarView.getVisibility() == 8) {
                fakeStatusBarView.setVisibility(0);
            }
            fakeStatusBarView.setBackgroundColor(StatusBarUtil.calculateStatusColor(color, statusBarAlpha));
        } else {
            StatusBarView statusBarView = new StatusBarView((Context)activity);
            statusBarView.setId(R.id.view_status_bar);
            statusBarView.setBackgroundColor(StatusBarUtil.calculateStatusColor(color, statusBarAlpha));
            contentLayout.addView((View)statusBarView, 0);
        }
        if (!hideStatusBarBackground && !(contentLayout instanceof LinearLayout) && contentLayout.getChildAt(1) != null) {
            int childCount = contentLayout.getChildCount();
            for (int i = 1; i < childCount; ++i) {
                View childAt = contentLayout.getChildAt(i);
                childAt.setPadding(contentLayout.getPaddingLeft(), StatusBarUtil.getStatusBarHeight((Context)activity) + contentLayout.getPaddingTop(), contentLayout.getPaddingRight(), contentLayout.getPaddingBottom());
            }
        }
        StatusBarUtil.setDrawerLayoutProperty(drawerLayout, contentLayout);
        return StatusBarUtil.transparencyBar(activity, StatusBarUtil.isNeedDark(color));
    }

    public static boolean immersiveStatusBarNeedDark(Activity activity, @ColorInt int color) {
        return StatusBarUtil.immersiveStatusBarNeedDark(activity, StatusBarUtil.isNeedDark(color));
    }

    public static boolean immersiveStatusBarNeedDark(Activity activity, boolean isDark) {
        if (activity == null) {
            return false;
        }
        if (StatusBarUtil.setStatusBarFontForMiui(activity, isDark)) {
            return true;
        }
        if (StatusBarUtil.setStatusBarFontForFlyme(activity, isDark)) {
            return true;
        }
        boolean isSuc = false;
        if (Build.VERSION.SDK_INT >= 23) {
            isSuc = StatusBarUtil.setStatusBarModeFor6_0(activity, isDark);
        }
        return isSuc;
    }

    private static boolean setStatusBarFontForMiui(@NonNull Activity activity, boolean darkIcon) {
        Class<?> clazz = activity.getWindow().getClass();
        try {
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            int darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)activity.getWindow(), darkIcon ? darkModeFlag : 0, darkModeFlag);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean setStatusBarFontForFlyme(@NonNull Activity activity, boolean darkIcon) {
        try {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = darkIcon ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            activity.getWindow().setAttributes(lp);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean setStatusBarModeFor6_0(Activity activity, boolean dark) {
        try {
            View decorView = activity.getWindow().getDecorView();
            int ui = decorView.getSystemUiVisibility();
            ui = dark ? (ui |= 0x2000) : (ui &= 0xFFFFDFFF);
            decorView.setSystemUiVisibility(ui);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        int result = resourceId > 0 ? context.getResources().getDimensionPixelSize(resourceId) : (int)Math.ceil(25.0f * context.getResources().getDisplayMetrics().density);
        return result;
    }

    private static boolean isNeedDark(@ColorInt int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        return Math.sqrt(Math.pow(1.0f - hsv[2], 2.0) + Math.pow(hsv[1], 2.0)) < 0.5;
    }

    private static int calculateStatusColor(@ColorInt int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private static void setDrawerLayoutProperty(DrawerLayout drawerLayout, ViewGroup drawerLayoutContentLayout) {
        ViewGroup drawer = (ViewGroup)drawerLayout.getChildAt(1);
        drawerLayout.setFitsSystemWindows(false);
        drawerLayoutContentLayout.setFitsSystemWindows(false);
        drawerLayoutContentLayout.setClipToPadding(true);
        drawer.setFitsSystemWindows(false);
    }
}

