/*
 * Decompiled with CFR 0.152.
 */
package com.to.aboomy.statusbar_lib;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.RequiresApi;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.to.aboomy.statusbar_lib.StatusBarView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtil {
    private static final String MANUFACTURER_XIAOMI = "Xiaomi";
    private static final String MANUFACTURER_MEIZU = "Meizu";

    @RequiresApi(api=21)
    public static void transparencyBar(Activity activity, @ColorInt int color) {
        Window window = activity.getWindow();
        window.clearFlags(0x4000000);
        window.getDecorView().setSystemUiVisibility(1280);
        window.addFlags(Integer.MIN_VALUE);
        window.setStatusBarColor(0);
        StatusBarUtil.setImmersiveStatusBarBackgroundColor(activity, StatusBarUtil.isNeedDark(color));
    }

    @RequiresApi(api=21)
    public static void drawerLayoutTransparencyBar(Activity activity, DrawerLayout drawerLayout, @ColorInt int color) {
        StatusBarUtil.drawerLayoutTransparencyBar(activity, color, drawerLayout, 0);
    }

    @RequiresApi(api=21)
    public static void drawerLayoutTransparencyBar(Activity activity, @ColorInt int color, DrawerLayout drawerLayout, int statusBarAlpha) {
        StatusBarUtil.transparencyBar(activity, color);
        ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
        View statusBar = contentLayout.getChildAt(0);
        if (statusBar != null && statusBar instanceof StatusBarView) {
            if (statusBar.getVisibility() == 8) {
                statusBar.setVisibility(0);
            }
            statusBar.setBackgroundColor(color);
        } else {
            StatusBarView statusBarView = new StatusBarView((Context)activity);
            statusBarView.setBackgroundColor(StatusBarUtil.calculateStatusColor(color, statusBarAlpha));
            contentLayout.addView((View)statusBarView, 0);
        }
        if (!(contentLayout instanceof LinearLayout) && contentLayout.getChildAt(1) != null) {
            contentLayout.getChildAt(1).setPadding(contentLayout.getPaddingLeft(), StatusBarUtil.getStatusBarHeight((Context)activity) + contentLayout.getPaddingTop(), contentLayout.getPaddingRight(), contentLayout.getPaddingBottom());
        }
        StatusBarUtil.setDrawerLayoutProperty(drawerLayout, contentLayout);
    }

    private static void setDrawerLayoutProperty(DrawerLayout drawerLayout, ViewGroup drawerLayoutContentLayout) {
        ViewGroup drawer = (ViewGroup)drawerLayout.getChildAt(1);
        drawerLayout.setFitsSystemWindows(false);
        drawerLayoutContentLayout.setFitsSystemWindows(false);
        drawerLayoutContentLayout.setClipToPadding(true);
        drawer.setFitsSystemWindows(false);
    }

    private static int calculateStatusColor(@ColorInt int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    @RequiresApi(api=21)
    public static boolean setImmersiveStatusBarBackgroundColor(Activity activity, @ColorInt int color) {
        boolean isSuc = StatusBarUtil.setImmersiveStatusBarBackgroundColor(activity, StatusBarUtil.isNeedDark(color));
        if (isSuc) {
            StatusBarUtil.setStatusBarColor(activity, color);
        }
        return isSuc;
    }

    private static boolean isNeedDark(@ColorInt int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        return Math.sqrt(Math.pow(1.0f - hsv[2], 2.0) + Math.pow(hsv[1], 2.0)) < 0.5;
    }

    @RequiresApi(api=21)
    public static void setStatusBarColor(Activity activity, @ColorInt int color) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color);
        }
    }

    public static boolean setImmersiveStatusBarBackgroundColor(Activity activity, boolean isDark) {
        if (activity == null) {
            return false;
        }
        boolean isSuc = false;
        if (Build.VERSION.SDK_INT >= 23) {
            isSuc = StatusBarUtil.setStatusBarModeFor6_0(activity.getWindow(), isDark);
            if (MANUFACTURER_XIAOMI.equals(Build.MANUFACTURER)) {
                if (StatusBarUtil.setStatusBarFontForMiui(activity.getWindow(), isDark)) {
                    isSuc = true;
                }
            } else if (MANUFACTURER_MEIZU.equals(Build.MANUFACTURER) && StatusBarUtil.setStatusBarFontForFlyme(activity.getWindow(), isDark)) {
                isSuc = true;
            }
        } else if (MANUFACTURER_XIAOMI.equals(Build.MANUFACTURER)) {
            if (StatusBarUtil.setStatusBarFontForMiui(activity.getWindow(), isDark)) {
                isSuc = true;
            }
        } else if (MANUFACTURER_MEIZU.equals(Build.MANUFACTURER) && StatusBarUtil.setStatusBarFontForFlyme(activity.getWindow(), isDark)) {
            isSuc = true;
        }
        return isSuc;
    }

    private static boolean setStatusBarFontForMiui(Window window, boolean dark) {
        if (window == null) {
            return false;
        }
        Class<?> clazz = window.getClass();
        try {
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            int darkModeFlag = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE").getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            if (dark) {
                extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
            } else {
                extraFlagField.invoke((Object)window, 0, darkModeFlag);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean setStatusBarFontForFlyme(Window window, boolean dark) {
        if (window == null) {
            return false;
        }
        try {
            WindowManager.LayoutParams lp = window.getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = dark ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            window.setAttributes(lp);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean setStatusBarFontForZuk(Window window, boolean dark) {
        if (window == null) {
            return false;
        }
        Class<?> clazz = window.getClass();
        try {
            Method setIcon = clazz.getMethod("setStatusBarIconColor", Integer.TYPE);
            int color = dark ? -16777216 : -1;
            setIcon.invoke((Object)window, color);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @RequiresApi(api=23)
    private static boolean setStatusBarModeFor6_0(Window window, boolean dark) {
        if (window == null) {
            return false;
        }
        try {
            View decorView = window.getDecorView();
            int ui = decorView.getSystemUiVisibility();
            ui = dark ? (ui |= 0x2000) : (ui &= 0xFFFFDFFF);
            decorView.setSystemUiVisibility(ui);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        int result = resourceId > 0 ? context.getResources().getDimensionPixelSize(resourceId) : (int)Math.ceil(25.0f * context.getResources().getDisplayMetrics().density);
        return result;
    }
}

