/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.convert;

import com.tngtech.junit.dataprovider.convert.ConverterContext;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;

public class StringConverter {
    protected static final Object OBJECT_NO_CONVERSION = new Object();

    public Object[] convert(String data, boolean isVarargs, Class<?>[] parameterTypes, ConverterContext context, int rowIdx) {
        if (data == null) {
            return new Object[]{null};
        }
        if (parameterTypes.length == 1) {
            if (isVarargs) {
                if (data.isEmpty()) {
                    return new Object[]{Array.newInstance(parameterTypes[0].getComponentType(), 0)};
                }
            } else {
                return new Object[]{this.convertValue(data, parameterTypes[0], context)};
            }
        }
        String[] splitData = this.splitBy(data, context.getSplitBy());
        this.checkArgumentsAndParameterCount(splitData.length, parameterTypes.length, isVarargs, rowIdx);
        return this.convert(splitData, isVarargs, parameterTypes, context);
    }

    protected String[] splitBy(String data, String regex) {
        String[] splitData = (data + "\u0000").split(regex);
        int lastItemIdx = splitData.length - 1;
        splitData[lastItemIdx] = splitData[lastItemIdx].substring(0, splitData[lastItemIdx].length() - 1);
        return splitData;
    }

    protected void checkArgumentsAndParameterCount(int argCount, int paramCount, boolean isVarargs, int rowIdx) {
        if (isVarargs && paramCount - 1 > argCount || !isVarargs && paramCount < argCount) {
            throw new IllegalArgumentException(String.format("%sest method has %d parameters but got %s%d arguments in row %d", isVarargs ? "Varargs t" : "T", paramCount, isVarargs ? "only " : "", argCount, rowIdx));
        }
    }

    private Object[] convert(String[] splitData, boolean isVarargs, Class<?>[] parameterTypes, ConverterContext context) {
        Object[] result = new Object[isVarargs ? parameterTypes.length : splitData.length];
        int nonVarargParametersLength = isVarargs ? parameterTypes.length - 1 : splitData.length;
        for (int idx = 0; idx < nonVarargParametersLength; ++idx) {
            result[idx] = this.convertValue(splitData[idx], parameterTypes[idx], context);
        }
        if (isVarargs) {
            Class<?> varargComponentType = parameterTypes[nonVarargParametersLength].getComponentType();
            Object varargArray = Array.newInstance(varargComponentType, splitData.length - parameterTypes.length + 1);
            for (int idx = nonVarargParametersLength; idx < splitData.length; ++idx) {
                Array.set(varargArray, idx - nonVarargParametersLength, this.convertValue(splitData[idx], varargComponentType, context));
            }
            result[nonVarargParametersLength] = varargArray;
        }
        return result;
    }

    private Object convertValue(String data, Class<?> targetType, ConverterContext context) {
        String str;
        String string = str = context.isTrimValues() ? data.trim() : data;
        if (context.isConvertNulls() && "null".equals(str)) {
            return null;
        }
        Object tmp = this.customConvertValue(str, targetType, context);
        if (tmp != OBJECT_NO_CONVERSION) {
            return tmp;
        }
        if (String.class.equals(targetType)) {
            return str;
        }
        Object primaryOrWrapper = this.convertPrimaryOrWrapper(str, targetType);
        if (primaryOrWrapper != null) {
            return primaryOrWrapper;
        }
        if (targetType.isEnum()) {
            Class<Enum> enumType = targetType;
            return this.convertToEnumValue(str, enumType, context.isIgnoreEnumCase());
        }
        if (Class.class.equals(targetType)) {
            try {
                return Class.forName(str);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Unable to instantiate '%s' for '%s'", targetType.getSimpleName(), str), e);
            }
        }
        Object result = this.tryConvertUsingSingleStringParamConstructor(str, targetType);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException(String.format("Type '%s' is not supported as parameter type of test methods. Supported types are primitive types and their wrappers, 'Enum' values, 'String's, and types having a single 'String' parameter constructor.", targetType.getSimpleName()));
    }

    protected Object customConvertValue(String str, Class<?> targetType, ConverterContext context) {
        return OBJECT_NO_CONVERSION;
    }

    protected Object convertPrimaryOrWrapper(String str, Class<?> targetType) {
        try {
            if (Boolean.TYPE.equals(targetType) || Boolean.class.equals(targetType)) {
                return Boolean.valueOf(str);
            }
            if (Byte.TYPE.equals(targetType) || Byte.class.equals(targetType)) {
                return Byte.valueOf(str);
            }
            if (Character.TYPE.equals(targetType) || Character.class.equals(targetType)) {
                if (str.length() == 1) {
                    return Character.valueOf(str.charAt(0));
                }
                throw new IllegalArgumentException(String.format("'%s' cannot be converted to type '%s'.", str, targetType.getSimpleName()));
            }
            if (Short.TYPE.equals(targetType) || Short.class.equals(targetType)) {
                return Short.valueOf(str);
            }
            if (Integer.TYPE.equals(targetType) || Integer.class.equals(targetType)) {
                return Integer.valueOf(str);
            }
            if (Long.TYPE.equals(targetType) || Long.class.equals(targetType)) {
                return this.convertToLong(str);
            }
            if (Float.TYPE.equals(targetType) || Float.class.equals(targetType)) {
                return Float.valueOf(str);
            }
            if (Double.TYPE.equals(targetType) || Double.class.equals(targetType)) {
                return Double.valueOf(str);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot convert '%s' to type '%s'", str, targetType.getSimpleName()), e);
        }
        return null;
    }

    protected Object convertToLong(String str) {
        String longStr = str;
        if (longStr.endsWith("l")) {
            longStr = longStr.substring(0, longStr.length() - 1);
        }
        return Long.valueOf(longStr);
    }

    protected Object convertToEnumValue(String str, Class<Enum> enumType, boolean ignoreEnumCase) {
        String errorMessage = "'%s' is not a valid value of enum '%s'.";
        if (ignoreEnumCase) {
            for (Enum enumConstant : enumType.getEnumConstants()) {
                if (!str.equalsIgnoreCase(enumConstant.name())) continue;
                return enumConstant;
            }
        } else {
            try {
                Enum result = Enum.valueOf(enumType, str);
                return result;
            }
            catch (IllegalArgumentException e) {
                errorMessage = errorMessage + " Please be aware of case sensitivity or use 'ignoreEnumCase'. Error was: " + e.getMessage();
            }
        }
        throw new IllegalArgumentException(String.format(errorMessage, str, enumType.getSimpleName()));
    }

    protected Object tryConvertUsingSingleStringParamConstructor(String str, Class<?> targetType) {
        for (Constructor<?> constructor : targetType.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !String.class.equals(constructor.getParameterTypes()[0])) continue;
            try {
                return constructor.newInstance(str);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Tried to invoke '%s' for argument '%s'. Exception was: %s", constructor, str, e.getMessage()), e);
            }
        }
        return null;
    }
}

