/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.convert;

import com.tngtech.junit.dataprovider.Preconditions;
import com.tngtech.junit.dataprovider.convert.ObjectArrayConverter;
import com.tngtech.junit.dataprovider.convert.SingleArgConverter;
import com.tngtech.junit.dataprovider.convert.StringConverter;

public class ConverterContext {
    public static final String COMMA = ",";
    public static final String NULL = "null";
    private final String splitBy;
    private final boolean convertNulls;
    private final boolean trimValues;
    private final boolean ignoreEnumCase;
    private final ObjectArrayConverter objectArrayConverter;
    private final SingleArgConverter singleArgConverter;
    private final StringConverter stringConverter;

    public ConverterContext(ObjectArrayConverter objectArrayConverter, SingleArgConverter singleArgConverter, StringConverter stringConverter, String splitBy, boolean convertNulls, boolean trimValues, boolean ignoreEnumCase) {
        this.splitBy = Preconditions.checkNotNull(splitBy, "'splitBy' must not be null");
        this.convertNulls = convertNulls;
        this.trimValues = trimValues;
        this.ignoreEnumCase = ignoreEnumCase;
        this.objectArrayConverter = Preconditions.checkNotNull(objectArrayConverter, "'objectArrayConverter' must not be null");
        this.singleArgConverter = Preconditions.checkNotNull(singleArgConverter, "'singleArgConverter' must not be null");
        this.stringConverter = Preconditions.checkNotNull(stringConverter, "'stringConverter' must not be null");
    }

    public ConverterContext(String splitBy, boolean convertNulls, boolean trimValues, boolean ignoreEnumCase) {
        this(new ObjectArrayConverter(), new SingleArgConverter(), new StringConverter(), splitBy, convertNulls, trimValues, ignoreEnumCase);
    }

    public String getSplitBy() {
        return this.splitBy;
    }

    public boolean isConvertNulls() {
        return this.convertNulls;
    }

    public boolean isTrimValues() {
        return this.trimValues;
    }

    public boolean isIgnoreEnumCase() {
        return this.ignoreEnumCase;
    }

    public ObjectArrayConverter getObjectArrayConverter() {
        return this.objectArrayConverter;
    }

    public SingleArgConverter getSingleArgConverter() {
        return this.singleArgConverter;
    }

    public StringConverter getStringConverter() {
        return this.stringConverter;
    }
}

