/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.convert;

import com.tngtech.junit.dataprovider.Preconditions;

public abstract class AbstractObjectConverter<V> {
    public abstract Object[] convert(V var1, boolean var2, Class<?>[] var3);

    protected void checkIfArgumentsMatchParameterTypes(Object[] arguments, Class<?>[] parameterTypes) {
        Preconditions.checkNotNull(arguments, "'arguments' must not be null");
        Preconditions.checkNotNull(parameterTypes, "'testMethod' must not be null");
        Preconditions.checkArgument(parameterTypes.length >= arguments.length, "Expected at most %d arguments for test method but got %d.", parameterTypes.length, arguments.length);
        for (int idx = 0; idx < arguments.length; ++idx) {
            Class<?> paramType;
            Object object = arguments[idx];
            if (object == null || (paramType = parameterTypes[idx]).isInstance(object) || this.isWrappedInstance(paramType, object) || this.isWideningConversion(paramType, object)) continue;
            throw new IllegalArgumentException(String.format("Parameter number %d is of type '%s' but argument given is '%s' of type '%s'", idx, paramType.getSimpleName(), object, object.getClass().getSimpleName()));
        }
    }

    private boolean isWrappedInstance(Class<?> clazz, Object object) {
        return Boolean.TYPE.equals(clazz) && object instanceof Boolean || Byte.TYPE.equals(clazz) && object instanceof Byte || Character.TYPE.equals(clazz) && object instanceof Character || Double.TYPE.equals(clazz) && object instanceof Double || Float.TYPE.equals(clazz) && object instanceof Float || Integer.TYPE.equals(clazz) && object instanceof Integer || Long.TYPE.equals(clazz) && object instanceof Long || Short.TYPE.equals(clazz) && object instanceof Short || Void.TYPE.equals(clazz) && object instanceof Void;
    }

    private boolean isWideningConversion(Class<?> clazz, Object object) {
        if ((Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && object instanceof Byte) {
            return true;
        }
        if ((Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && (object instanceof Short || object instanceof Character)) {
            return true;
        }
        if ((Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && object instanceof Integer) {
            return true;
        }
        if ((Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && object instanceof Long) {
            return true;
        }
        return Double.TYPE.equals(clazz) && object instanceof Float;
    }
}

