/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.common.Preconditions;
import com.tngtech.java.junit.dataprovider.internal.convert.ObjectArrayConverter;
import com.tngtech.java.junit.dataprovider.internal.convert.SingleArgConverter;
import com.tngtech.java.junit.dataprovider.internal.convert.StringConverter;
import com.tngtech.junit.dataprovider.convert.ConverterContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="for backwards compatibility and easier migration to core")
public class DataConverter
extends com.tngtech.junit.dataprovider.convert.DataConverter {
    private ObjectArrayConverter objectArrayConverter = new ObjectArrayConverter();
    private SingleArgConverter singleArgConverter = new SingleArgConverter();
    private StringConverter stringConverter = new StringConverter();

    public boolean canConvert(Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof Class) {
            return Object[][].class.equals((Object)type) || Object[].class.equals((Object)type) || String[].class.equals((Object)type);
        }
        if (type instanceof ParameterizedType && Iterable.class.isAssignableFrom((Class)(rawType = (parameterizedType = (ParameterizedType)type).getRawType()))) {
            return this.canConvertIterableOf(parameterizedType);
        }
        return false;
    }

    public List<Object[]> convert(Object data, boolean isVarargs, Class<?>[] parameterTypes, DataProvider dataProvider) {
        Preconditions.checkNotNull(dataProvider, "dataProvider must not be null");
        ConverterContext context = new ConverterContext((com.tngtech.junit.dataprovider.convert.ObjectArrayConverter)this.objectArrayConverter, (com.tngtech.junit.dataprovider.convert.SingleArgConverter)this.singleArgConverter, (com.tngtech.junit.dataprovider.convert.StringConverter)this.stringConverter, dataProvider.splitBy(), dataProvider.convertNulls(), dataProvider.trimValues(), dataProvider.ignoreEnumCase());
        return super.convert(data, isVarargs, (Class[])parameterTypes, context);
    }

    private boolean canConvertIterableOf(ParameterizedType parameterizedType) {
        if (parameterizedType.getActualTypeArguments().length == 1) {
            Type innerType = parameterizedType.getActualTypeArguments()[0];
            if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType) {
                ParameterizedType innerType2 = (ParameterizedType)innerType;
                return Iterable.class.isAssignableFrom((Class)innerType2.getRawType());
            }
            return true;
        }
        return false;
    }

    public void setObjectArrayConverter(ObjectArrayConverter objectArrayConverter) {
        this.objectArrayConverter = objectArrayConverter;
    }

    public void setSingleArgConverter(SingleArgConverter singleArgConverter) {
        this.singleArgConverter = singleArgConverter;
    }

    public void setStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
    }
}

