/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider;

import com.tngtech.junit.dataprovider.DataProviderParameterResolver;
import com.tngtech.junit.dataprovider.DisplayNameContext;
import com.tngtech.junit.dataprovider.Preconditions;
import com.tngtech.junit.dataprovider.format.DataProviderPlaceholderFormatter;
import com.tngtech.junit.dataprovider.format.DataProviderTestNameFormatter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.platform.commons.util.ReflectionUtils;

class DataProviderInvocationContext
implements TestTemplateInvocationContext {
    private final Method testMethod;
    private final List<Object> arguments;
    private final DisplayNameContext displayNameContext;

    DataProviderInvocationContext(Method testMethod, List<Object> arguments, DisplayNameContext displayNameContext) {
        this.testMethod = (Method)Preconditions.checkNotNull((Object)testMethod, (String)"'testMethod' must not be null");
        this.arguments = new ArrayList<Object>((Collection)Preconditions.checkNotNull(arguments, (String)"'arguments' must not be null"));
        this.displayNameContext = (DisplayNameContext)Preconditions.checkNotNull((Object)displayNameContext, (String)"'displayNameContext' must not be null");
    }

    public String getDisplayName(int invocationIndex) {
        Class<? extends DataProviderTestNameFormatter> formatter = this.displayNameContext.getFormatter();
        if (formatter == null || DataProviderPlaceholderFormatter.class.equals(formatter)) {
            return new DataProviderPlaceholderFormatter(this.displayNameContext.getFormat(), this.displayNameContext.getPlaceholders()).format(this.testMethod, invocationIndex, this.arguments);
        }
        return ((DataProviderTestNameFormatter)ReflectionUtils.newInstance(formatter, (Object[])new Object[0])).format(this.testMethod, invocationIndex, this.arguments);
    }

    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList(new DataProviderParameterResolver(this.arguments));
    }
}

