/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.integration.spring;

import com.tngtech.jgiven.impl.ByteBuddyStageClassCreator;
import com.tngtech.jgiven.impl.CachingStageClassCreator;
import com.tngtech.jgiven.impl.StageClassCreator;
import com.tngtech.jgiven.integration.spring.JGivenStage;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class JGivenBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private final StageClassCreator stageClassCreator = new CachingStageClassCreator((StageClassCreator)new ByteBuddyStageClassCreator());

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            AnnotatedBeanDefinition annotatedBeanDefinition;
            BeanDefinition beanDefinition;
            if (!beanFactory.containsBeanDefinition(beanName) || !((beanDefinition = beanFactory.getBeanDefinition(beanName)) instanceof AnnotatedBeanDefinition) || !(annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition).getMetadata().hasAnnotation(JGivenStage.class.getName())) continue;
            String className = beanDefinition.getBeanClassName();
            Class<?> stageClass = this.createStageClass(beanName, className);
            beanDefinition.setBeanClassName(stageClass.getName());
        }
    }

    private Class<?> createStageClass(String beanName, String className) {
        try {
            Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            return this.stageClassCreator.createStageClass(aClass);
        }
        catch (ClassNotFoundException e) {
            throw new FatalBeanException("Error while trying to create JGiven stage for bean " + beanName, (Throwable)e);
        }
    }
}

