/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.StepModel;

final class ExecutionStatusCalculator
extends ReportModelVisitor {
    private int failedCount;
    private int pendingCount;
    private int totalCount;
    private ExecutionStatus status;

    ExecutionStatusCalculator() {
    }

    @Override
    public void visit(StepModel stepModel) {
        if (stepModel.isFailed()) {
            ++this.failedCount;
        } else if (stepModel.isPending()) {
            ++this.pendingCount;
        }
        ++this.totalCount;
    }

    public ExecutionStatus executionStatus() {
        if (this.status != null) {
            return this.status;
        }
        if (this.failedCount > 0) {
            return ExecutionStatus.FAILED;
        }
        if (this.pendingCount > 0) {
            if (this.pendingCount < this.totalCount) {
                return ExecutionStatus.SOME_STEPS_PENDING;
            }
            return ExecutionStatus.SCENARIO_PENDING;
        }
        return ExecutionStatus.SUCCESS;
    }
}

