/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.report.ReportModelHandler;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import java.util.ArrayList;
import java.util.List;

public class AbstractReportModelHandler {
    public void handle(ReportModel reportModel, ReportModelHandler handler) {
        reportModel.accept(new ReportModelHandlerVisitor(handler));
    }

    public static interface ScenarioDataTable {
        public List<String> placeHolders();

        public List<Row> rows();

        public static interface Row {
            public int nr();

            public ExecutionStatus status();

            public List<String> arguments();
        }
    }

    private static class ReportModelHandlerVisitor
    extends ReportModelVisitor {
        private final ReportModelHandler handler;
        private boolean isMultiCase;
        private boolean hasDataTable;
        private ScenarioModel currentScenarioModel;
        private boolean skipCase;

        public ReportModelHandlerVisitor(ReportModelHandler handler) {
            this.handler = handler;
        }

        @Override
        public void visit(ReportModel reportModel) {
            this.handler.className(reportModel.getClassName());
            if (reportModel.getDescription() != null) {
                this.handler.reportDescription(reportModel.getDescription());
            }
        }

        @Override
        public void visit(ScenarioModel scenarioModel) {
            this.handler.scenarioTitle(scenarioModel.getDescription());
            this.currentScenarioModel = scenarioModel;
            this.isMultiCase = scenarioModel.getScenarioCases().size() > 1;
            this.hasDataTable = scenarioModel.isCasesAsTable();
        }

        @Override
        public void visitEnd(ScenarioModel scenarioModel) {
            if (this.hasDataTable) {
                this.handler.dataTable(new ScenarioDataTableImpl(scenarioModel));
            }
            this.handler.scenarioEnd();
        }

        @Override
        public void visit(ScenarioCaseModel scenarioCase) {
            if (scenarioCase.getCaseNr() > 1 && this.hasDataTable) {
                this.skipCase = true;
                return;
            }
            this.skipCase = false;
            if (this.isMultiCase && !this.hasDataTable) {
                this.handler.caseHeader(scenarioCase.getCaseNr(), this.currentScenarioModel.getExplicitParameters(), scenarioCase.getExplicitArguments());
            }
        }

        @Override
        public void visit(StepModel stepModel) {
            if (this.skipCase) {
                return;
            }
            this.handler.stepStart();
            for (Word word : stepModel.getWords()) {
                if (word.isIntroWord()) {
                    this.handler.introWord(word.getValue());
                    continue;
                }
                if (word.isArg()) {
                    if (word.getArgumentInfo().isParameter()) {
                        if (this.hasDataTable) {
                            this.handler.stepArgumentPlaceHolder(word.getArgumentInfo().getParameterName());
                            continue;
                        }
                        this.handler.stepCaseArgument(word.getFormattedValue());
                        continue;
                    }
                    if (word.getArgumentInfo().isDataTable()) {
                        this.handler.stepDataTableArgument(word.getArgumentInfo().getDataTable());
                        continue;
                    }
                    this.handler.stepArgument(word.getFormattedValue(), word.isDifferent());
                    continue;
                }
                this.handler.stepWord(word.getFormattedValue(), word.isDifferent());
            }
            this.handler.stepEnd();
        }

        private static class ScenarioDataTableImpl
        implements ScenarioDataTable {
            private final ScenarioModel scenarioModel;

            private ScenarioDataTableImpl(ScenarioModel scenarioModel) {
                this.scenarioModel = scenarioModel;
            }

            @Override
            public List<String> placeHolders() {
                return this.scenarioModel.getDerivedParameters();
            }

            @Override
            public List<ScenarioDataTable.Row> rows() {
                ArrayList rows = Lists.newArrayList();
                for (ScenarioCaseModel caseModel : this.scenarioModel.getScenarioCases()) {
                    rows.add(new RowImpl(caseModel));
                }
                return rows;
            }

            private static class RowImpl
            implements ScenarioDataTable.Row {
                private final ScenarioCaseModel caseModel;

                public RowImpl(ScenarioCaseModel caseModel) {
                    this.caseModel = caseModel;
                }

                @Override
                public int nr() {
                    return this.caseModel.getCaseNr();
                }

                @Override
                public ExecutionStatus status() {
                    return this.caseModel.getExecutionStatus();
                }

                @Override
                public List<String> arguments() {
                    return this.caseModel.getDerivedArguments();
                }
            }
        }
    }
}

