/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.util;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;

public final class WordUtil {
    private WordUtil() {
    }

    public static String capitalize(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.substring(0, 1).toUpperCase().concat(text.substring(1, text.length()));
    }

    public static String lowerCaseFirstChar(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.substring(0, 1).toLowerCase().concat(text.substring(1, text.length()));
    }

    public static String camelCase(String string) {
        return WordUtil.lowerCaseFirstChar(Joiner.on((String)"").join((Iterable)FluentIterable.from((Iterable)Splitter.on((char)'_').split((CharSequence)string)).transform(WordUtil.capitalize())));
    }

    private static Function<String, String> capitalize() {
        return new Function<String, String>(){

            public String apply(String arg) {
                return WordUtil.capitalize(arg);
            }
        };
    }

    public static String splitCamelCaseToReadableText(String camelCase) {
        return camelCase.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public static String camelCaseToCapitalizedReadableText(String camelCase) {
        return WordUtil.capitalize(WordUtil.camelCaseToReadableText(camelCase));
    }

    public static String camelCaseToReadableText(String camelCase) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, camelCase).replace('_', ' ');
    }

    public static String fromSnakeCase(String name) {
        return name.replace('_', ' ');
    }

    public static boolean isAllUpperCase(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (Ascii.isUpperCase((char)name.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

