/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.inject;

import com.google.common.base.Function;
import com.tngtech.jgiven.annotation.ExpectedScenarioState;
import com.tngtech.jgiven.annotation.ProvidedScenarioState;
import com.tngtech.jgiven.annotation.ScenarioState;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

final class ScenarioStateField {
    public static Function<Field, ScenarioStateField> fromField = new Function<Field, ScenarioStateField>(){

        public ScenarioStateField apply(Field field) {
            return new ScenarioStateField(field);
        }
    };
    private final Field field;
    private ScenarioState.Resolution declaredResolution;
    private boolean required;

    private ScenarioStateField(Field field) {
        this.field = field;
        this.collectAnnotations(field);
        if (this.declaredResolution == null) {
            throw new IllegalArgumentException("Field " + field + " has no valid annotation");
        }
    }

    public Field getField() {
        return this.field;
    }

    public ScenarioState.Resolution getResolution() {
        if (this.declaredResolution == ScenarioState.Resolution.AUTO) {
            return this.typeIsTooGeneric(this.field.getType()) ? ScenarioState.Resolution.NAME : ScenarioState.Resolution.TYPE;
        }
        return this.declaredResolution;
    }

    public boolean isRequired() {
        return this.required;
    }

    private void collectAnnotations(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (this.declaredResolution == null) {
                this.declaredResolution = this.collectDeclaredResolution(annotation);
            }
            this.required |= this.collectRequired(annotation);
        }
    }

    private ScenarioState.Resolution collectDeclaredResolution(Annotation annotation) {
        if (annotation instanceof ScenarioState) {
            return ((ScenarioState)annotation).resolution();
        }
        if (annotation instanceof ProvidedScenarioState) {
            return ((ProvidedScenarioState)annotation).resolution();
        }
        if (annotation instanceof ExpectedScenarioState) {
            return ((ExpectedScenarioState)annotation).resolution();
        }
        return null;
    }

    private boolean collectRequired(Annotation annotation) {
        if (annotation instanceof ScenarioState) {
            return ((ScenarioState)annotation).required();
        }
        if (annotation instanceof ExpectedScenarioState) {
            return ((ExpectedScenarioState)annotation).required();
        }
        return false;
    }

    private boolean typeIsTooGeneric(Class<?> type) {
        return type.isPrimitive() || type.getName().startsWith("java.lang") || type.getName().startsWith("java.io") || type.getName().startsWith("java.util");
    }
}

