/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.tngtech.jgiven.impl.StageClassCreator;
import java.util.concurrent.ConcurrentHashMap;

public class CachingStageClassCreator
implements StageClassCreator {
    private StageClassCreator stageCreator;
    private static final ConcurrentHashMap<Class<?>, Class<?>> createdStages = new ConcurrentHashMap(50);

    public CachingStageClassCreator(StageClassCreator stageCreator) {
        this.stageCreator = stageCreator;
    }

    @Override
    public <T> Class<? extends T> createStageClass(Class<T> stageClass) {
        return CachingStageClassCreator.getCachedClass(stageClass, this.stageCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Class<? extends T> getCachedClass(Class<T> stageClass, StageClassCreator stageCreator) {
        Class<Object> stageSubClass = createdStages.get(stageClass);
        if (stageSubClass == null) {
            ConcurrentHashMap<Class<?>, Class<?>> concurrentHashMap = createdStages;
            synchronized (concurrentHashMap) {
                stageSubClass = stageCreator.createStageClass(stageClass);
                createdStages.put(stageClass, stageSubClass);
            }
        }
        return stageSubClass;
    }
}

