/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderFrameworkMethod;
import com.tngtech.java.junit.dataprovider.internal.DataConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGenerator {
    private final DataConverter dataConverter;

    public TestGenerator(DataConverter dataConverter) {
        if (dataConverter == null) {
            throw new NullPointerException("dataConverter must not be null");
        }
        this.dataConverter = dataConverter;
    }

    public List<FrameworkMethod> generateExplodedTestMethodsFor(FrameworkMethod testMethod, FrameworkMethod dataProviderMethod) {
        if (testMethod == null) {
            return Collections.emptyList();
        }
        if (dataProviderMethod != null) {
            return this.explodeTestMethod(testMethod, dataProviderMethod);
        }
        DataProvider dataProvider = (DataProvider)testMethod.getAnnotation(DataProvider.class);
        if (dataProvider != null) {
            return this.explodeTestMethod(testMethod, dataProvider);
        }
        return Arrays.asList(testMethod);
    }

    List<FrameworkMethod> explodeTestMethod(FrameworkMethod testMethod, FrameworkMethod dataProviderMethod) {
        Object data;
        try {
            Class<?>[] parameterTypes = dataProviderMethod.getMethod().getParameterTypes();
            data = parameterTypes.length > 0 ? dataProviderMethod.invokeExplosively(null, new Object[]{testMethod}) : dataProviderMethod.invokeExplosively(null, new Object[0]);
        }
        catch (Throwable t) {
            throw new Error(String.format("Exception while invoking data provider method '%s': %s", dataProviderMethod.getName(), t.getMessage()), t);
        }
        DataConverter.Settings settings = new DataConverter.Settings((DataProvider)dataProviderMethod.getAnnotation(DataProvider.class));
        List<Object[]> converted = this.dataConverter.convert(data, testMethod.getMethod().getParameterTypes(), settings);
        String emptyResultMessage = String.format("Data provider '%s' must neither be null nor empty but was: %s.", dataProviderMethod.getName(), data);
        return this.explodeTestMethod(testMethod, converted, emptyResultMessage);
    }

    List<FrameworkMethod> explodeTestMethod(FrameworkMethod testMethod, DataProvider dataProvider) {
        Object[] data = dataProvider.value();
        List<Object[]> converted = this.dataConverter.convert(data, testMethod.getMethod().getParameterTypes(), new DataConverter.Settings(dataProvider));
        String emptyResultMessage = String.format("%s.value() must be set but was: %s.", dataProvider.getClass().getSimpleName(), Arrays.toString(data));
        return this.explodeTestMethod(testMethod, converted, emptyResultMessage);
    }

    private List<FrameworkMethod> explodeTestMethod(FrameworkMethod testMethod, List<Object[]> converted, String emptyResultMessage) {
        int idx = 0;
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        for (Object[] parameters : converted) {
            result.add(new DataProviderFrameworkMethod(testMethod.getMethod(), idx++, parameters));
        }
        if (result.isEmpty()) {
            throw new Error(emptyResultMessage);
        }
        return result;
    }
}

