/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import com.tngtech.java.junit.dataprovider.internal.ParametersFormatter;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.runners.model.FrameworkMethod;

public class DataProviderFrameworkMethod
extends FrameworkMethod {
    final int idx;
    final Object[] parameters;
    private ParametersFormatter formatter;

    public DataProviderFrameworkMethod(Method method, int idx, Object[] parameters) {
        super(method);
        if (parameters == null) {
            throw new NullPointerException("parameter must not be null");
        }
        if (parameters.length == 0) {
            throw new IllegalArgumentException("parameter must not be empty");
        }
        this.idx = idx;
        this.parameters = Arrays.copyOf(parameters, parameters.length);
        this.formatter = new ParametersFormatter();
    }

    public String getName() {
        return String.format("%s[%d: %s]", super.getName(), this.idx, this.formatter.format(this.parameters));
    }

    public Object invokeExplosively(Object target, Object ... params) throws Throwable {
        return super.invokeExplosively(target, this.parameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.idx;
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataProviderFrameworkMethod other = (DataProviderFrameworkMethod)((Object)obj);
        if (this.idx != other.idx) {
            return false;
        }
        return Arrays.equals(this.parameters, other.parameters);
    }

    void setFormatter(ParametersFormatter formatter) {
        this.formatter = formatter;
    }
}

