/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal.convert;

public abstract class AbstractObjectConverter<V> {
    public abstract Object[] convert(V var1, boolean var2, Class<?>[] var3);

    protected void checkIfArgumentsMatchParameterTypes(Object[] arguments, Class<?>[] parameterTypes) {
        if (arguments == null) {
            throw new NullPointerException("arguments must not be null");
        }
        if (parameterTypes == null) {
            throw new NullPointerException("testMethod must not be null");
        }
        if (parameterTypes.length != arguments.length) {
            throw new IllegalArgumentException(String.format("Expected %s arguments for test method but got %s parameters.", parameterTypes.length, arguments.length));
        }
        for (int idx = 0; idx < arguments.length; ++idx) {
            Class<?> paramType;
            Object object = arguments[idx];
            if (object == null || (paramType = parameterTypes[idx]).isInstance(object) || this.isWrappedInstance(paramType, object) || this.isWideningConversion(paramType, object)) continue;
            throw new IllegalArgumentException(String.format("Parameter %d is of type %s but argument given is %s of type %s", idx, paramType.getSimpleName(), object, object.getClass().getSimpleName()));
        }
    }

    private boolean isWrappedInstance(Class<?> clazz, Object object) {
        return Boolean.TYPE.equals(clazz) && Boolean.class.isInstance(object) || Byte.TYPE.equals(clazz) && Byte.class.isInstance(object) || Character.TYPE.equals(clazz) && Character.class.isInstance(object) || Double.TYPE.equals(clazz) && Double.class.isInstance(object) || Float.TYPE.equals(clazz) && Float.class.isInstance(object) || Integer.TYPE.equals(clazz) && Integer.class.isInstance(object) || Long.TYPE.equals(clazz) && Long.class.isInstance(object) || Short.TYPE.equals(clazz) && Short.class.isInstance(object) || Void.TYPE.equals(clazz) && Void.class.isInstance(object);
    }

    private boolean isWideningConversion(Class<?> clazz, Object object) {
        if ((Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && Byte.class.isInstance(object)) {
            return true;
        }
        if ((Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && (Short.class.isInstance(object) || Character.class.isInstance(object))) {
            return true;
        }
        if ((Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && Integer.class.isInstance(object)) {
            return true;
        }
        if ((Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) && Long.class.isInstance(object)) {
            return true;
        }
        return Double.TYPE.equals(clazz) && Float.class.isInstance(object);
    }
}

