/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class ArchUnitSystemPropertyTestFilterJUnit5 {
    private static final String JUNIT_TEST_FILTER_PROPERTY_NAME = "junit.testFilter";
    private static final Set<String> MEMBER_SEGMENT_TYPES = ImmutableSet.of((Object)"field", (Object)"method");

    ArchUnitSystemPropertyTestFilterJUnit5() {
    }

    void filter(TestDescriptor descriptor) {
        ArchConfiguration configuration = ArchConfiguration.get();
        if (!configuration.containsProperty(JUNIT_TEST_FILTER_PROPERTY_NAME)) {
            return;
        }
        String testFilterProperty = configuration.getProperty(JUNIT_TEST_FILTER_PROPERTY_NAME);
        List memberNames = Splitter.on((String)",").splitToList((CharSequence)testFilterProperty);
        Predicate<TestDescriptor> shouldRunPredicate = testDescriptor -> ArchUnitSystemPropertyTestFilterJUnit5.memberNameMatches(testDescriptor, memberNames);
        this.removeNonMatching(descriptor, shouldRunPredicate);
    }

    private void removeNonMatching(TestDescriptor descriptor, Predicate<TestDescriptor> shouldRunPredicate) {
        ImmutableSet.copyOf((Collection)descriptor.getChildren()).forEach(child -> this.removeNonMatching((TestDescriptor)child, shouldRunPredicate));
        if (descriptor.getChildren().isEmpty() && !shouldRunPredicate.test(descriptor)) {
            descriptor.removeFromHierarchy();
        }
    }

    private static boolean memberNameMatches(TestDescriptor testDescriptor, List<String> memberNames) {
        UniqueId.Segment lastSegment = testDescriptor.getUniqueId().getLastSegment();
        return MEMBER_SEGMENT_TYPES.contains(lastSegment.getType()) && memberNames.stream().anyMatch(it -> lastSegment.getValue().equals(it));
    }
}

