/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.junit.ArchIgnore;
import com.tngtech.archunit.junit.ArchTests;
import com.tngtech.archunit.junit.internal.ArchTestExecution;
import com.tngtech.archunit.junit.internal.ReflectionUtils;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;

abstract class ArchRuleDeclaration<T extends AnnotatedElement> {
    final List<Class<?>> testClassPath;
    final T declaration;
    final Class<?> owner;
    private final boolean forceIgnore;

    ArchRuleDeclaration(List<Class<?>> testClassPath, T declaration, Class<?> owner, boolean forceIgnore) {
        this.testClassPath = testClassPath;
        this.declaration = declaration;
        this.owner = owner;
        this.forceIgnore = forceIgnore;
    }

    abstract void handleWith(Handler var1);

    private static ArchRuleDeclaration<Method> from(List<Class<?>> testClassPath, Method method, Class<?> methodOwner, boolean forceIgnore) {
        return new AsMethod(testClassPath, method, methodOwner, forceIgnore);
    }

    private static ArchRuleDeclaration<Field> from(List<Class<?>> testClassPath, Field field, Class<?> fieldOwner, boolean forceIgnore) {
        return new AsField(testClassPath, field, fieldOwner, forceIgnore);
    }

    static boolean elementShouldBeIgnored(Class<?> owner, AnnotatedElement ruleDeclaration) {
        return owner.getAnnotation(ArchIgnore.class) != null || ruleDeclaration.getAnnotation(ArchIgnore.class) != null;
    }

    boolean shouldBeIgnored() {
        return this.forceIgnore || ArchRuleDeclaration.elementShouldBeIgnored(this.owner, this.declaration);
    }

    static Set<ArchRuleDeclaration<?>> toDeclarations(ArchTests archTests, List<Class<?>> testClassPath, Class<? extends Annotation> archTestAnnotationType, boolean forceIgnore) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        Class<?> definitionLocation = archTests.getDefinitionLocation();
        ImmutableList childTestClassPath = ImmutableList.builder().addAll(testClassPath).add(definitionLocation).build();
        for (Field field : ReflectionUtils.getAllFields(definitionLocation, ReflectionUtils.withAnnotation(archTestAnnotationType))) {
            result.addAll(ArchRuleDeclaration.archRuleDeclarationsFrom(childTestClassPath, field, definitionLocation, archTestAnnotationType, forceIgnore));
        }
        for (Method method : ReflectionUtils.getAllMethods(definitionLocation, ReflectionUtils.withAnnotation(archTestAnnotationType))) {
            result.add(ArchRuleDeclaration.from(childTestClassPath, method, definitionLocation, forceIgnore));
        }
        return result.build();
    }

    private static Set<ArchRuleDeclaration<?>> archRuleDeclarationsFrom(List<Class<?>> testClassPath, Field field, Class<?> fieldOwner, Class<? extends Annotation> archTestAnnotationType, boolean forceIgnore) {
        return ArchTests.class.isAssignableFrom(field.getType()) ? ArchRuleDeclaration.toDeclarations(ArchRuleDeclaration.getArchTestsIn(field, fieldOwner), testClassPath, archTestAnnotationType, forceIgnore || ArchRuleDeclaration.elementShouldBeIgnored(fieldOwner, field)) : Collections.singleton(ArchRuleDeclaration.from(testClassPath, field, fieldOwner, forceIgnore));
    }

    private static ArchTests getArchTestsIn(Field field, Class<?> fieldOwner) {
        ArchTests value = (ArchTests)ArchTestExecution.getValue(field, fieldOwner);
        return (ArchTests)Preconditions.checkNotNull((Object)value, (String)"Field %s.%s is not initialized", (Object)fieldOwner.getName(), (Object)field.getName());
    }

    private static class AsMethod
    extends ArchRuleDeclaration<Method> {
        AsMethod(List<Class<?>> testClassPath, Method method, Class<?> methodOwner, boolean forceIgnore) {
            super(testClassPath, method, methodOwner, forceIgnore);
        }

        @Override
        void handleWith(Handler handler) {
            handler.handleMethodDeclaration(this.testClassPath, (Method)this.declaration, this.owner, this.shouldBeIgnored());
        }
    }

    private static class AsField
    extends ArchRuleDeclaration<Field> {
        AsField(List<Class<?>> testClassPath, Field field, Class<?> fieldOwner, boolean forceIgnore) {
            super(testClassPath, field, fieldOwner, forceIgnore);
        }

        @Override
        void handleWith(Handler handler) {
            handler.handleFieldDeclaration(this.testClassPath, (Field)this.declaration, this.owner, this.shouldBeIgnored());
        }
    }

    static interface Handler {
        public void handleFieldDeclaration(List<Class<?>> var1, Field var2, Class<?> var3, boolean var4);

        public void handleMethodDeclaration(List<Class<?>> var1, Method var2, Class<?> var3, boolean var4);
    }
}

