/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.junit.internal.ArchTestInitializationException;
import com.tngtech.archunit.junit.internal.ReflectionUtils;
import java.lang.reflect.Field;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

abstract class ArchTestExecution {
    final Class<?> testClass;
    private final boolean ignore;

    ArchTestExecution(Class<?> testClass, boolean ignore) {
        this.testClass = testClass;
        this.ignore = ignore;
    }

    abstract Result evaluateOn(JavaClasses var1);

    abstract Description describeSelf();

    public String toString() {
        return this.describeSelf().toString();
    }

    abstract String getName();

    boolean ignore() {
        return this.ignore;
    }

    static <T> T getValue(Field field, Class<?> fieldOwner) {
        return ReflectionUtils.getValueOrThrowException(field, fieldOwner, ArchTestInitializationException::new);
    }

    static class NegativeResult
    extends Result {
        private final Description description;
        private final Throwable failure;

        NegativeResult(Description description, Throwable failure) {
            this.description = description;
            this.failure = failure;
        }

        @Override
        void notify(RunNotifier notifier) {
            notifier.fireTestFailure(new Failure(this.description, this.failure));
        }
    }

    static class PositiveResult
    extends Result {
        PositiveResult() {
        }

        @Override
        void notify(RunNotifier notifier) {
        }
    }

    static abstract class Result {
        Result() {
        }

        abstract void notify(RunNotifier var1);
    }
}

