/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.core.importer.ImportOptions;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.core.importer.Locations;
import com.tngtech.archunit.junit.CacheMode;
import com.tngtech.archunit.junit.LocationProvider;
import com.tngtech.archunit.junit.internal.ArchTestExecutionException;
import com.tngtech.archunit.junit.internal.ClassAnalysisRequest;
import com.tngtech.archunit.junit.internal.ReflectionUtils;
import com.tngtech.archunit.thirdparty.com.google.common.annotations.VisibleForTesting;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheBuilder;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheLoader;
import com.tngtech.archunit.thirdparty.com.google.common.cache.LoadingCache;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

class ClassCache {
    @VisibleForTesting
    final Map<Class<?>, JavaClasses> cachedByTest = new ConcurrentHashMap();
    @VisibleForTesting
    final LoadingCache<LocationsKey, LazyJavaClasses> cachedByLocations = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<LocationsKey, LazyJavaClasses>(){

        public LazyJavaClasses load(LocationsKey key) {
            return new LazyJavaClasses(key.locations, key.importOptionTypes);
        }
    });
    private CacheClassFileImporter cacheClassFileImporter = new CacheClassFileImporter();

    ClassCache() {
    }

    JavaClasses getClassesToAnalyzeFor(Class<?> testClass, ClassAnalysisRequest classAnalysisRequest) {
        Preconditions.checkNotNull(testClass);
        Preconditions.checkNotNull((Object)classAnalysisRequest);
        if (this.cachedByTest.containsKey(testClass)) {
            return this.cachedByTest.get(testClass);
        }
        LocationsKey locations = RequestedLocations.by(classAnalysisRequest, testClass).asKey();
        JavaClasses classes = classAnalysisRequest.getCacheMode() == CacheMode.FOREVER ? ((LazyJavaClasses)this.cachedByLocations.getUnchecked((Object)locations)).get() : new LazyJavaClasses(locations.locations, locations.importOptionTypes).get();
        this.cachedByTest.put(testClass, classes);
        return classes;
    }

    void clear(Class<?> testClass) {
        this.cachedByTest.remove(testClass);
    }

    static class CacheClassFileImporter {
        CacheClassFileImporter() {
        }

        JavaClasses importClasses(ImportOptions importOptions, Collection<Location> locations) {
            return new ClassFileImporter(importOptions).importLocations(locations);
        }
    }

    private static abstract class RequestedLocations {
        private RequestedLocations() {
        }

        abstract LocationsKey asKey();

        public static RequestedLocations by(ClassAnalysisRequest classAnalysisRequest, Class<?> testClass) {
            return RequestedLocations.noSpecificLocationRequested(classAnalysisRequest) ? new AllInTestPackage(classAnalysisRequest.getImportOptions(), testClass) : new Specific(classAnalysisRequest, testClass);
        }

        private static boolean noSpecificLocationRequested(ClassAnalysisRequest classAnalysisRequest) {
            return classAnalysisRequest.getPackageNames().length == 0 && classAnalysisRequest.getPackageRoots().length == 0 && classAnalysisRequest.getLocationProviders().length == 0 && !classAnalysisRequest.scanWholeClasspath();
        }

        private static class AllInTestPackage
        extends RequestedLocations {
            private final Class<? extends ImportOption>[] importOptions;
            private final Set<Location> locationsOfTestPackage;

            private AllInTestPackage(Class<? extends ImportOption>[] importOptions, Class<?> testClass) {
                this.importOptions = importOptions;
                this.locationsOfTestPackage = Locations.ofPackage((String)testClass.getPackage().getName());
            }

            @Override
            LocationsKey asKey() {
                return new LocationsKey(this.importOptions, this.locationsOfTestPackage);
            }
        }

        private static class Specific
        extends RequestedLocations {
            private final Class<? extends ImportOption>[] importOptions;
            private final Set<Location> declaredLocations;

            private Specific(ClassAnalysisRequest classAnalysisRequest, Class<?> testClass) {
                this.importOptions = classAnalysisRequest.getImportOptions();
                this.declaredLocations = ImmutableSet.builder().addAll(this.getLocationsOfPackages(classAnalysisRequest)).addAll(this.getLocationsOfProviders(classAnalysisRequest, testClass)).addAll(classAnalysisRequest.scanWholeClasspath() ? Locations.inClassPath() : Collections.emptySet()).build();
            }

            private Set<Location> getLocationsOfPackages(ClassAnalysisRequest classAnalysisRequest) {
                ImmutableSet packages = ImmutableSet.builder().add((Object[])classAnalysisRequest.getPackageNames()).addAll(this.toPackageStrings(classAnalysisRequest.getPackageRoots())).build();
                return this.locationsOf((Set<String>)packages);
            }

            private Set<Location> getLocationsOfProviders(ClassAnalysisRequest classAnalysisRequest, Class<?> testClass) {
                return Arrays.stream(classAnalysisRequest.getLocationProviders()).flatMap(providerClass -> this.tryCreate((Class<? extends LocationProvider>)providerClass).get(testClass).stream()).collect(Collectors.toSet());
            }

            private LocationProvider tryCreate(Class<? extends LocationProvider> providerClass) {
                try {
                    return ReflectionUtils.newInstanceOf(providerClass);
                }
                catch (RuntimeException e) {
                    String message = String.format("Failed to create %s. It must be accessible and provide a public default constructor", providerClass.getSimpleName());
                    throw new ArchTestExecutionException(message, e);
                }
            }

            private Set<String> toPackageStrings(Class<?>[] classes) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (Class<?> clazz : classes) {
                    result.add((Object)clazz.getPackage().getName());
                }
                return result.build();
            }

            private Set<Location> locationsOf(Set<String> packages) {
                return packages.stream().flatMap(pkg -> Locations.ofPackage((String)pkg).stream()).collect(Collectors.toSet());
            }

            @Override
            LocationsKey asKey() {
                return new LocationsKey(this.importOptions, this.declaredLocations);
            }
        }
    }

    private static class LocationsKey {
        private final Set<Class<? extends ImportOption>> importOptionTypes;
        private final Set<Location> locations;

        private LocationsKey(Class<? extends ImportOption>[] importOptionTypes, Set<Location> locations) {
            this.importOptionTypes = ImmutableSet.copyOf((Object[])importOptionTypes);
            this.locations = locations;
        }

        public int hashCode() {
            return Objects.hash(this.importOptionTypes, this.locations);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LocationsKey other = (LocationsKey)obj;
            return Objects.equals(this.importOptionTypes, other.importOptionTypes) && Objects.equals(this.locations, other.locations);
        }
    }

    private class LazyJavaClasses {
        private final Set<Location> locations;
        private final Set<Class<? extends ImportOption>> importOptionTypes;
        private volatile JavaClasses javaClasses;

        private LazyJavaClasses(Set<Location> locations, Set<Class<? extends ImportOption>> importOptionTypes) {
            this.locations = locations;
            this.importOptionTypes = importOptionTypes;
        }

        public JavaClasses get() {
            if (this.javaClasses == null) {
                this.initialize();
            }
            return this.javaClasses;
        }

        private synchronized void initialize() {
            if (this.javaClasses == null) {
                ImportOptions importOptions = new ImportOptions();
                for (Class<? extends ImportOption> optionClass : this.importOptionTypes) {
                    importOptions = importOptions.with(ReflectionUtils.newInstanceOf(optionClass));
                }
                this.javaClasses = ClassCache.this.cacheClassFileImporter.importClasses(importOptions, this.locations);
            }
        }
    }
}

