/*
 * Decompiled with CFR 0.152.
 */
package com.titusfortner.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class SeleniumFilter
implements Filter {
    private final List<String> logAllowedList = new ArrayList<String>(List.of("org.openqa.selenium"));
    private final List<String> logBlockList = new ArrayList<String>(List.of("opentelemetry"));

    public void addAllowed(String allowed) {
        Objects.requireNonNull(allowed);
        this.logAllowedList.add(allowed);
    }

    public List<String> getLogAllowedList() {
        return this.logAllowedList;
    }

    public void addBlocked(String blocked) {
        Objects.requireNonNull(blocked);
        this.logBlockList.add(blocked);
    }

    public void clear() {
        this.logAllowedList.clear();
        this.logBlockList.clear();
    }

    public List<String> getLogBlockList() {
        return this.logBlockList;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        String loggerName = record.getLoggerName();
        return this.getLogAllowedList().stream().filter(loggerName::contains).anyMatch(_a -> this.getLogBlockList().stream().noneMatch(loggerName::contains));
    }
}

