/*
 * Decompiled with CFR 0.152.
 */
package com.titusfortner.logging;

import java.io.File;

public abstract class DriverLogger {
    protected abstract String getLogProperty();

    protected abstract void ensureLevel();

    public void disable() {
        System.setProperty(this.getLogProperty(), "/dev/null");
    }

    public String getOutput() {
        return System.getProperty(this.getLogProperty());
    }

    public void setFile(File fileName) {
        System.setProperty(this.getLogProperty(), fileName.getAbsolutePath());
        this.ensureLevel();
    }

    public File getFile() {
        String path = this.getOutput();
        return path == null || !new File(path).isFile() ? null : new File(path);
    }

    protected void ensureOutput() {
        if (this.getOutput() == null) {
            System.setProperty(this.getLogProperty(), "/dev/stderr");
        }
    }

    protected void ensureEnabled() {
        this.ensureOutput();
        this.ensureLevel();
    }
}

