/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.util;

import com.tencent.tinker.commons.util.IOHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public final class DigestUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(File file) throws IOException {
        long l;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            l = DigestUtil.getCRC32(is);
        }
        catch (Throwable throwable) {
            IOHelper.closeQuietly(is);
            throw throwable;
        }
        IOHelper.closeQuietly(is);
        return l;
    }

    public static long getCRC32(byte[] data, int off, int length) {
        CRC32 crc32 = new CRC32();
        crc32.update(data, off, length);
        return crc32.getValue();
    }

    public static long getCRC32(InputStream is) throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = is.read(buffer)) > 0) {
            crc32.update(buffer, 0, bytesRead);
        }
        return crc32.getValue();
    }

    private DigestUtil() {
        throw new UnsupportedOperationException();
    }
}

