/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.algorithms.patch;

import com.tencent.tinker.android.dex.DebugInfoItem;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.commons.dexpatcher.algorithms.patch.DexSectionPatchAlgorithm;
import com.tencent.tinker.commons.dexpatcher.struct.DexPatchFile;
import com.tencent.tinker.commons.dexpatcher.util.AbstractIndexMap;
import com.tencent.tinker.commons.dexpatcher.util.SparseIndexMap;

public class DebugInfoItemSectionPatchAlgorithm
extends DexSectionPatchAlgorithm<DebugInfoItem> {
    private TableOfContents.Section patchedDebugInfoItemTocSec = null;
    private Dex.Section patchedDebugInfoItemSec = null;

    public DebugInfoItemSectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, SparseIndexMap oldToPatchedIndexMap) {
        super(patchFile, oldDex, oldToPatchedIndexMap);
        if (patchedDex != null) {
            this.patchedDebugInfoItemTocSec = patchedDex.getTableOfContents().debugInfos;
            this.patchedDebugInfoItemSec = patchedDex.openSection(this.patchedDebugInfoItemTocSec);
        }
    }

    @Override
    protected TableOfContents.Section getTocSection(Dex dex) {
        return dex.getTableOfContents().debugInfos;
    }

    @Override
    protected DebugInfoItem nextItem(DexDataBuffer section) {
        return section.readDebugInfoItem();
    }

    @Override
    protected int getItemSize(DebugInfoItem item) {
        return item.byteCountInDex();
    }

    @Override
    protected DebugInfoItem adjustItem(AbstractIndexMap indexMap, DebugInfoItem item) {
        return indexMap.adjust(item);
    }

    @Override
    protected int writePatchedItem(DebugInfoItem patchedItem) {
        ++this.patchedDebugInfoItemTocSec.size;
        return this.patchedDebugInfoItemSec.writeDebugInfoItem(patchedItem);
    }

    @Override
    protected void updateIndexOrOffset(SparseIndexMap sparseIndexMap, int oldIndex, int oldOffset, int newIndex, int newOffset) {
        if (oldOffset != newOffset) {
            sparseIndexMap.mapDebugInfoItemOffset(oldOffset, newOffset);
        }
    }

    @Override
    protected void markDeletedIndexOrOffset(SparseIndexMap sparseIndexMap, int deletedIndex, int deletedOffset) {
        sparseIndexMap.markDebugInfoItemDeleted(deletedOffset);
    }
}

