/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.app;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import com.tencent.tinker.loader.TinkerLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerUncaughtHandler;
import com.tencent.tinker.loader.app.ApplicationLike;
import com.tencent.tinker.loader.hotplug.ComponentHotplug;
import com.tencent.tinker.loader.hotplug.UnsupportedEnvironmentException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class TinkerApplication
extends Application {
    private static final int TINKER_DISABLE = 0;
    private static final String INTENT_PATCH_EXCEPTION = "intent_patch_exception";
    private static final String TINKER_LOADER_METHOD = "tryLoad";
    private final int tinkerFlags;
    private final boolean tinkerLoadVerifyFlag;
    private final String delegateClassName;
    private final String loaderClassName;
    private boolean useSafeMode;
    private Intent tinkerResultIntent;
    private ApplicationLike applicationLike = null;
    private long applicationStartElapsedTime;
    private long applicationStartMillisTime;

    protected TinkerApplication(int tinkerFlags) {
        this(tinkerFlags, "com.tencent.tinker.loader.app.DefaultApplicationLike", TinkerLoader.class.getName(), false);
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName, String loaderClassName, boolean tinkerLoadVerifyFlag) {
        this.tinkerFlags = tinkerFlags;
        this.delegateClassName = delegateClassName;
        this.loaderClassName = loaderClassName;
        this.tinkerLoadVerifyFlag = tinkerLoadVerifyFlag;
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName) {
        this(tinkerFlags, delegateClassName, TinkerLoader.class.getName(), false);
    }

    private ApplicationLike createDelegate() {
        try {
            Class<?> delegateClass = Class.forName(this.delegateClassName, false, this.getClassLoader());
            Constructor<?> constructor = delegateClass.getConstructor(Application.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Intent.class);
            return (ApplicationLike)constructor.newInstance(new Object[]{this, this.tinkerFlags, this.tinkerLoadVerifyFlag, this.applicationStartElapsedTime, this.applicationStartMillisTime, this.tinkerResultIntent});
        }
        catch (Throwable e) {
            throw new TinkerRuntimeException("createDelegate failed", e);
        }
    }

    private synchronized void ensureDelegate() {
        if (this.applicationLike == null) {
            this.applicationLike = this.createDelegate();
        }
    }

    private void onBaseContextAttached(Context base) {
        this.applicationStartElapsedTime = SystemClock.elapsedRealtime();
        this.applicationStartMillisTime = System.currentTimeMillis();
        this.loadTinker();
        this.ensureDelegate();
        this.applicationLike.onBaseContextAttached(base);
        if (this.useSafeMode) {
            String processName = ShareTinkerInternals.getProcessName((Context)this);
            String preferName = "tinker_own_config_" + processName;
            SharedPreferences sp = this.getSharedPreferences(preferName, 0);
            sp.edit().putInt("safe_mode_count", 0).commit();
        }
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        Thread.setDefaultUncaughtExceptionHandler(new TinkerUncaughtHandler((Context)this));
        this.onBaseContextAttached(base);
    }

    private void loadTinker() {
        try {
            Class<?> tinkerLoadClass = Class.forName(this.loaderClassName, false, this.getClassLoader());
            Method loadMethod = tinkerLoadClass.getMethod(TINKER_LOADER_METHOD, TinkerApplication.class);
            Constructor<?> constructor = tinkerLoadClass.getConstructor(new Class[0]);
            this.tinkerResultIntent = (Intent)loadMethod.invoke(constructor.newInstance(new Object[0]), new Object[]{this});
        }
        catch (Throwable e) {
            this.tinkerResultIntent = new Intent();
            ShareIntentUtil.setIntentReturnCode(this.tinkerResultIntent, -20);
            this.tinkerResultIntent.putExtra(INTENT_PATCH_EXCEPTION, (Serializable)e);
        }
    }

    public void onCreate() {
        super.onCreate();
        this.ensureDelegate();
        try {
            ComponentHotplug.ensureComponentHotplugInstalled(this);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new TinkerRuntimeException("failed to make sure that ComponentHotplug logic is fine.", e);
        }
        this.applicationLike.onCreate();
    }

    public void onTerminate() {
        super.onTerminate();
        if (this.applicationLike != null) {
            this.applicationLike.onTerminate();
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.applicationLike != null) {
            this.applicationLike.onLowMemory();
        }
    }

    @TargetApi(value=14)
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (this.applicationLike != null) {
            this.applicationLike.onTrimMemory(level);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.applicationLike != null) {
            this.applicationLike.onConfigurationChanged(newConfig);
        }
    }

    public Resources getResources() {
        Resources resources = super.getResources();
        if (this.applicationLike != null) {
            return this.applicationLike.getResources(resources);
        }
        return resources;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = super.getClassLoader();
        if (this.applicationLike != null) {
            return this.applicationLike.getClassLoader(classLoader);
        }
        return classLoader;
    }

    public AssetManager getAssets() {
        AssetManager assetManager = super.getAssets();
        if (this.applicationLike != null) {
            return this.applicationLike.getAssets(assetManager);
        }
        return assetManager;
    }

    public Object getSystemService(String name) {
        Object service = super.getSystemService(name);
        if (this.applicationLike != null) {
            return this.applicationLike.getSystemService(name, service);
        }
        return service;
    }

    public Context getBaseContext() {
        Context base = super.getBaseContext();
        if (this.applicationLike != null) {
            return this.applicationLike.getBaseContext(base);
        }
        return base;
    }

    public void setUseSafeMode(boolean useSafeMode) {
        this.useSafeMode = useSafeMode;
    }

    public boolean isTinkerLoadVerifyFlag() {
        return this.tinkerLoadVerifyFlag;
    }

    public int getTinkerFlags() {
        return this.tinkerFlags;
    }
}

